package com.bailuntec.job;

import com.bailuntec.domain.entity.DcBaseCrmRefund;
import com.bailuntec.domain.entity.DcBaseOmsOrder;
import com.bailuntec.domain.entity.JobPointLog;
import com.bailuntec.domain.example.DcBaseCrmRefundExample;
import com.bailuntec.domain.example.DcBaseOmsOrderExample;
import com.bailuntec.mapper.DcBaseCrmRefundMapper;
import com.bailuntec.mapper.DcBaseOmsOrderMapper;
import com.bailuntec.support.PointJob;
import com.bailuntec.utils.SessionUtil;
import com.dangdang.ddframe.job.api.ShardingContext;
import lombok.extern.slf4j.Slf4j;

import java.util.List;

@Slf4j
public class RefundLinkOrderJob extends PointJob {

    public void executeRefundJob(JobPointLog jobPointLog) {
        long count = 0;
        try {
            DcBaseCrmRefundMapper refundMapper = SessionUtil.getSession().getMapper(DcBaseCrmRefundMapper.class);
            count = refundMapper.countByExample(DcBaseCrmRefundExample.newAndCreateCriteria().andLinkedEqualTo(false).example());
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Mybatis查询DB失败");
        } finally {
            SessionUtil.closeSession();
        }
        long totalPage;
        if (count % jobPointLog.getPageSize() == 0) {
            totalPage = count / jobPointLog.getPageSize();
        } else {
            totalPage = count / jobPointLog.getPageSize() + 1;
        }
        if (totalPage > 0) {
            for (int i = 0; i <= totalPage; i++) {
                List<DcBaseCrmRefund> dcBaseCrmRefundList = null;
                try {
                    DcBaseCrmRefundMapper refundMapper1 = SessionUtil.getSession().getMapper(DcBaseCrmRefundMapper.class);
                    dcBaseCrmRefundList = refundMapper1.selectByExample(DcBaseCrmRefundExample.newAndCreateCriteria().andLinkedEqualTo(false).example().limit(i * jobPointLog.getPageSize(), jobPointLog.getPageSize()));
                } catch (Exception e) {
                    throw new RuntimeException("Mybatis操作DB失败", e);
                } finally {
                    SessionUtil.closeSession();
                }
                if (dcBaseCrmRefundList != null && dcBaseCrmRefundList.size() > 0) {
                    for (DcBaseCrmRefund dcBaseCrmRefund : dcBaseCrmRefundList) {
                        log.warn(dcBaseCrmRefund.getOriginOrderId() +"------" + dcBaseCrmRefund.getBailunAccountId() +"------" + dcBaseCrmRefund.getBailunSku());
                        DcBaseOmsOrder dcBaseOmsOrder = null;
                        try {
                            DcBaseOmsOrderMapper omsOrderMapper = SessionUtil.getSession().getMapper(DcBaseOmsOrderMapper.class);
                            /**
                             * 这里这么switch
                             * 是因为CRM的单号和OMS的订单号规则不一样, 取的不一样的字段
                             * 新平台需要自己去查
                             */
                            switch (dcBaseCrmRefund.getPlatformType().toUpperCase()) {
                                case "EBAY":
                                    dcBaseOmsOrder = omsOrderMapper.selectOneByExample(DcBaseOmsOrderExample.newAndCreateCriteria().andBailunAccountIdEqualTo(dcBaseCrmRefund.getBailunAccountId()).andTransactionIdEqualTo(dcBaseCrmRefund.getOriginOrderId()).example());
                                    break;
                                case "WALMART":
                                    dcBaseOmsOrder = omsOrderMapper.selectOneByExample(DcBaseOmsOrderExample.newAndCreateCriteria().andBailunAccountIdEqualTo(dcBaseCrmRefund.getBailunAccountId()).andBuyerIdEqualTo(dcBaseCrmRefund.getOriginOrderId()).example());
                                    break;
                                default:
                                    dcBaseOmsOrder = omsOrderMapper.selectOneByExample(DcBaseOmsOrderExample.newAndCreateCriteria().andBailunAccountIdEqualTo(dcBaseCrmRefund.getBailunAccountId()).andOriginOrderIdEqualTo(dcBaseCrmRefund.getOriginOrderId()).example());
                            }
                            if (dcBaseOmsOrder != null) {
                                dcBaseOmsOrder.setAmountRefund(dcBaseOmsOrder.getAmountRefund() != null ? dcBaseOmsOrder.getAmountRefund().add(dcBaseCrmRefund.getAmountRefund()) : dcBaseCrmRefund.getAmountRefund());
                                dcBaseOmsOrder.setRefundTime(dcBaseCrmRefund.getRefundTime());
                                dcBaseOmsOrder.setBailunRefundStatus("TotalRefund");
                                dcBaseCrmRefund.setLinked(true);
                                DcBaseCrmRefundMapper refundMapper2 = SessionUtil.getTranstionSession().getMapper(DcBaseCrmRefundMapper.class);
                                DcBaseOmsOrderMapper omsOrderMapper2 = SessionUtil.getTranstionSession().getMapper(DcBaseOmsOrderMapper.class);
                                omsOrderMapper2.updateByPrimaryKeySelective(dcBaseOmsOrder);
                                refundMapper2.updateByPrimaryKeySelective(dcBaseCrmRefund);
                            }
                        } catch (Exception e) {
                            e.printStackTrace();
                            log.error("退款与订单关联失败",e);
                        } finally {
                            SessionUtil.closeSession();
                            SessionUtil.closeTranstionSession();
                        }
                    }
                }
            }
        }
    }

    @Override
    public void executeJob(ShardingContext shardingContext, JobPointLog jobPointLog) {
        executeRefundJob(jobPointLog);
    }
}

