package com.bailuntec.domain.pojo;

public class SkuConditionDto {
    private String updateDate;

    /// <summary>
    /// 返回数据类型，1正常，2分页，99导出
    /// </summary>
    private Integer resultType;

    /// <summary>
    /// 查询内容
    /// 1-1主要基础,1-2规格,1-3基础其他，2开发，3状态，4供应商，5商品,例：1-1,2,3
    /// </summary>
    private String resultContent;

    /// <summary>
    /// sku(多个sku以,间隔，上限1000)
    /// </summary>
    private String skus;

    /// <summary>
    /// 页数
    /// </summary>
    private Integer page;

    /// <summary>
    /// 分页大小，最大1000
    /// </summary>
    private Integer pageSize;

    /// <summary>
    /// 排序列
    /// </summary>
    private String sortField;

    /// <summary>
    /// 排序方式 asc或desc
    /// </summary>
    private String sort;

    /// <summary>
    /// 查询类型 1产品编码，2商品编码，3标题模糊查询，4内部商品编码，5内部产品编码
    /// </summary>
    private Integer searchType;

    /// <summary>
    /// 查询值
    /// </summary>
    private String search;

    /// <summary>
    /// 采购员Id
    /// </summary>
    private Integer buyerId;

    /// <summary>
    /// 销售员Id
    /// </summary>
    private Integer sellerId;

    /// <summary>
    /// 商品状态 1停售，2在售
    /// </summary>
    private Integer status;

    /// <summary>
    /// 是否成品 -1,都返回 1成品，2半成品，3耗材，4固定资产，5组合SKU
    /// </summary>
    private Integer isFinish;

    /// <summary>
    /// 是否返回供应商 1是返回sku对应供应商列表，2否不返回
    /// </summary>
    private Integer isResultSup;

    /// <summary>
    /// 是否返回仓库信息
    /// </summary>
    private Integer isResultWare;


    public Integer getResultType() {
        return resultType;
    }

    public void setResultType(Integer resultType) {
        this.resultType = resultType;
    }

    public String getResultContent() {
        return resultContent;
    }

    public void setResultContent(String resultContent) {
        this.resultContent = resultContent;
    }

    public String getSkus() {
        return skus;
    }

    public void setSkus(String skus) {
        this.skus = skus;
    }

    public Integer getPage() {
        return page;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public String getSortField() {
        return sortField;
    }

    public void setSortField(String sortField) {
        this.sortField = sortField;
    }

    public String getSort() {
        return sort;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    public Integer getSearchType() {
        return searchType;
    }

    public void setSearchType(Integer searchType) {
        this.searchType = searchType;
    }

    public String getSearch() {
        return search;
    }

    public void setSearch(String search) {
        this.search = search;
    }

    public Integer getBuyerId() {
        return buyerId;
    }

    public void setBuyerId(Integer buyerId) {
        this.buyerId = buyerId;
    }

    public Integer getSellerId() {
        return sellerId;
    }

    public void setSellerId(Integer sellerId) {
        this.sellerId = sellerId;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Integer getIsFinish() {
        return isFinish;
    }

    public void setIsFinish(Integer isFinish) {
        this.isFinish = isFinish;
    }

    public Integer getIsResultSup() {
        return isResultSup;
    }

    public void setIsResultSup(Integer isResultSup) {
        this.isResultSup = isResultSup;
    }

    public Integer getIsResultWare() {
        return isResultWare;
    }

    public void setIsResultWare(Integer isResultWare) {
        this.isResultWare = isResultWare;
    }

    public String getUpdateDate() {
        return updateDate;
    }

    public void setUpdateDate(String updateDate) {
        this.updateDate = updateDate;
    }
}
