package com.bailuntec.job;

import com.bailuntec.domain.entity.DcBaseCrmRefund;
import com.bailuntec.domain.entity.DcBaseOmsOrder;
import com.bailuntec.domain.entity.DcBaseOmsSku;
import com.bailuntec.domain.entity.JobPointLog;
import com.bailuntec.domain.example.DcBaseCrmRefundExample;
import com.bailuntec.domain.example.DcBaseOmsOrderExample;
import com.bailuntec.domain.example.DcBaseOmsSkuExample;
import com.bailuntec.mapper.DcBaseCrmRefundMapper;
import com.bailuntec.mapper.DcBaseOmsOrderMapper;
import com.bailuntec.mapper.DcBaseOmsSkuMapper;
import com.bailuntec.support.PointJob;
import com.bailuntec.utils.SessionUtil;
import com.dangdang.ddframe.job.api.ShardingContext;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;

public class RefundLinkOrderJob extends PointJob {

    public void executeRefundJob(JobPointLog jobPointLog) {
        long count = 0;
        try {
            DcBaseCrmRefundMapper refundMapper = SessionUtil.getSession().getMapper(DcBaseCrmRefundMapper.class);
            count = refundMapper.countByExample(DcBaseCrmRefundExample.newAndCreateCriteria().andLinkedEqualTo(false).example());
            SessionUtil.getSession().commit();
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Mybatis查询DB失败");
        } finally {
            SessionUtil.closeSession();
        }
        long totalPage;
        if (count % jobPointLog.getPageSize() == 0) {
            totalPage = count / jobPointLog.getPageSize();
        } else {
            totalPage = count / jobPointLog.getPageSize() + 1;
        }
        if (totalPage > 0) {
            for (int i = 0; i <= totalPage; i++) {
                try {
                    DcBaseCrmRefundMapper refundMapper1 = SessionUtil.getSession().getMapper(DcBaseCrmRefundMapper.class);
                    DcBaseOmsSkuMapper omsSkuMapper = SessionUtil.getSession().getMapper(DcBaseOmsSkuMapper.class);
                    DcBaseOmsOrderMapper omsOrderMapper = SessionUtil.getSession().getMapper(DcBaseOmsOrderMapper.class);
                    List<DcBaseCrmRefund> dcBaseCrmRefundList = refundMapper1.selectByExample(DcBaseCrmRefundExample.newAndCreateCriteria().andLinkedEqualTo(false).example().limit(i * jobPointLog.getPageSize(), jobPointLog.getPageSize()));
                    if (dcBaseCrmRefundList != null && dcBaseCrmRefundList.size() > 0) {
                        for (DcBaseCrmRefund dcBaseCrmRefund : dcBaseCrmRefundList) {
                            DcBaseOmsSku dcBaseOmsSku = null;
                            DcBaseOmsOrder dcBaseOmsOrder = null;
                            switch (dcBaseCrmRefund.getPlatformType().toUpperCase()) {
                                case "EBAY":
                                    dcBaseOmsSku = omsSkuMapper.selectOneByExample(DcBaseOmsSkuExample.newAndCreateCriteria().andBailunAccountIdEqualTo(dcBaseCrmRefund.getBailunAccountId()).andTransactionIdEqualTo(dcBaseCrmRefund.getOriginOrderId()).andBailunSkuEqualTo(dcBaseCrmRefund.getBailunSku()).example());
                                    dcBaseOmsOrder = omsOrderMapper.selectOneByExample(DcBaseOmsOrderExample.newAndCreateCriteria().andBailunAccountIdEqualTo(dcBaseCrmRefund.getBailunAccountId()).andTransactionIdEqualTo(dcBaseCrmRefund.getOriginOrderId()).example());
                                    break;
                                case "WALMART":
                                    dcBaseOmsSku = omsSkuMapper.selectOneByExample(DcBaseOmsSkuExample.newAndCreateCriteria().andBailunAccountIdEqualTo(dcBaseCrmRefund.getBailunAccountId()).andBuyerIdEqualTo(dcBaseCrmRefund.getOriginOrderId()).andBailunSkuEqualTo(dcBaseCrmRefund.getBailunSku()).example());
                                    dcBaseOmsOrder = omsOrderMapper.selectOneByExample(DcBaseOmsOrderExample.newAndCreateCriteria().andBailunAccountIdEqualTo(dcBaseCrmRefund.getBailunAccountId()).andBuyerIdEqualTo(dcBaseCrmRefund.getOriginOrderId()).example());
                                    break;
                                default:
                                    dcBaseOmsSku = omsSkuMapper.selectOneByExample(DcBaseOmsSkuExample.newAndCreateCriteria().andBailunAccountIdEqualTo(dcBaseCrmRefund.getBailunAccountId()).andOriginOrderIdEqualTo(dcBaseCrmRefund.getOriginOrderId()).andBailunSkuEqualTo(dcBaseCrmRefund.getBailunSku()).example());
                                    dcBaseOmsOrder = omsOrderMapper.selectOneByExample(DcBaseOmsOrderExample.newAndCreateCriteria().andBailunAccountIdEqualTo(dcBaseCrmRefund.getBailunAccountId()).andOriginOrderIdEqualTo(dcBaseCrmRefund.getOriginOrderId()).example());
                            }
                            if (dcBaseOmsOrder != null && dcBaseOmsSku != null) {
                                //利润要减去退款
                                //利润率要重算
                                dcBaseOmsOrder.setAmountRefund(dcBaseOmsOrder.getAmountRefund() != null ? dcBaseOmsOrder.getAmountRefund().add(dcBaseCrmRefund.getAmountRefund()) : dcBaseCrmRefund.getAmountRefund());
                                dcBaseOmsOrder.setRefundTime(dcBaseCrmRefund.getRefundTime());
                                BigDecimal profit = dcBaseOmsOrder.getProfitTotal().subtract(dcBaseOmsOrder.getAmountRefund().multiply(dcBaseOmsOrder.getSellerOrderExchangeRate())).setScale(3, RoundingMode.HALF_EVEN);
                                dcBaseOmsOrder.setProfitTotal(profit);
                                BigDecimal amountSales = dcBaseOmsOrder.getAmountSales().multiply(dcBaseOmsOrder.getSellerOrderExchangeRate());
                                dcBaseOmsOrder.setProfitRate(amountSales.compareTo(BigDecimal.ZERO) == 0?BigDecimal.ZERO :  profit.divide(amountSales,5,RoundingMode.HALF_EVEN));
                                //利润要减去退款
                                //利润率要重算
                                BigDecimal quantityOrderedDecimal = BigDecimal.valueOf(dcBaseOmsSku.getBailunSkuQuantityOrdered());
                                //退款摊到单个SKU
                                dcBaseOmsSku.setAmountRefund(dcBaseCrmRefund.getAmountRefund().divide(quantityOrderedDecimal.compareTo(BigDecimal.ZERO) == 1? quantityOrderedDecimal : BigDecimal.ONE, 3, BigDecimal.ROUND_HALF_EVEN));
                                dcBaseOmsSku.setRefundTime(dcBaseCrmRefund.getRefundTime());
                                BigDecimal profitSku = dcBaseOmsSku.getProfitTotal().subtract(dcBaseOmsSku.getAmountRefund().multiply(dcBaseOmsSku.getSellerOrderExchangeRate())).setScale(3, RoundingMode.HALF_EVEN);
                                dcBaseOmsSku.setProfitTotal(profitSku);
                                BigDecimal amountSalesSku = dcBaseOmsSku.getAmountSales().multiply(dcBaseOmsSku.getSellerOrderExchangeRate());
                                dcBaseOmsOrder.setProfitRate(amountSalesSku.compareTo(BigDecimal.ZERO) == 0?BigDecimal.ZERO :  profitSku.divide(amountSalesSku,5,RoundingMode.HALF_EVEN));
                                dcBaseCrmRefund.setLinked(true);
                                omsSkuMapper.updateByPrimaryKeySelective(dcBaseOmsSku);
                                omsOrderMapper.updateByPrimaryKeySelective(dcBaseOmsOrder);
                                refundMapper1.updateByPrimaryKeySelective(dcBaseCrmRefund);
                            }
                        }
                    }
                    SessionUtil.getSession().commit();
                } catch (Exception e) {
                    e.printStackTrace();
                    SessionUtil.getSession().rollback();
                    throw new RuntimeException("Mybatis操作DB失败");
                } finally {
                    SessionUtil.closeSession();
                }
            }
        }
    }

    @Override
    public void executeJob(ShardingContext shardingContext, JobPointLog jobPointLog) {
        executeRefundJob(jobPointLog);
    }
}

