package com.bailuntec.domain.entity;

import javax.persistence.*;
import java.time.LocalDateTime;

@Entity
@Table(name = "dc_base_stock", schema = "bailun_datacenter")
public class DcBaseStock {
    private Integer id;
    private String bailunSku;
    private String warehouseCode;
    private String ownerCode;
    private Integer quantityReservation;
    private Integer quantityTransport;
    private Integer quantityTransfer;
    private Integer quantityFreeze;
    private Integer quantitySupplier;
    private Integer quantityPresell;
    private Integer quantityDefective;
    private Integer quantityTransit;
    private Integer waitCheck;
    private Integer waitPutaway;
    private Integer usableStock;
    private Integer usableSales;
    private Integer usableSalesPrivate;
    private Integer usableSalesShare;
    private Integer inWarehouseShare;
    private Integer inWarehousePrivate;
    private Integer inWarehouse;
    private Integer occupyStockShare;
    private Integer occupyStockPrivate;
    private Integer occupyStock;
    private Integer occupyActivity;
    private Integer occupyOrderPrivate;
    private Integer occupyOrderShare;
    private Integer occupyOrder;
    private LocalDateTime gmtCreate;
    private LocalDateTime gmtModified;
    private LocalDateTime createTime;
    private LocalDateTime updateTime;

    @Id
    @Column(name = "id")
    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @Basic
    @Column(name = "bailun_sku")
    public String getBailunSku() {
        return bailunSku;
    }

    public void setBailunSku(String bailunSku) {
        this.bailunSku = bailunSku;
    }

    @Basic
    @Column(name = "warehouse_code")
    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    @Basic
    @Column(name = "owner_code")
    public String getOwnerCode() {
        return ownerCode;
    }

    public void setOwnerCode(String ownerCode) {
        this.ownerCode = ownerCode;
    }

    @Basic
    @Column(name = "quantity_reservation")
    public Integer getQuantityReservation() {
        return quantityReservation;
    }

    public void setQuantityReservation(Integer quantityReservation) {
        this.quantityReservation = quantityReservation;
    }

    @Basic
    @Column(name = "quantity_transport")
    public Integer getQuantityTransport() {
        return quantityTransport;
    }

    public void setQuantityTransport(Integer quantityTransport) {
        this.quantityTransport = quantityTransport;
    }

    @Basic
    @Column(name = "quantity_transfer")
    public Integer getQuantityTransfer() {
        return quantityTransfer;
    }

    public void setQuantityTransfer(Integer quantityTransfer) {
        this.quantityTransfer = quantityTransfer;
    }

    @Basic
    @Column(name = "quantity_freeze")
    public Integer getQuantityFreeze() {
        return quantityFreeze;
    }

    public void setQuantityFreeze(Integer quantityFreeze) {
        this.quantityFreeze = quantityFreeze;
    }

    @Basic
    @Column(name = "quantity_supplier")
    public Integer getQuantitySupplier() {
        return quantitySupplier;
    }

    public void setQuantitySupplier(Integer quantitySupplier) {
        this.quantitySupplier = quantitySupplier;
    }

    @Basic
    @Column(name = "quantity_presell")
    public Integer getQuantityPresell() {
        return quantityPresell;
    }

    public void setQuantityPresell(Integer quantityPresell) {
        this.quantityPresell = quantityPresell;
    }

    @Basic
    @Column(name = "quantity_defective")
    public Integer getQuantityDefective() {
        return quantityDefective;
    }

    public void setQuantityDefective(Integer quantityDefective) {
        this.quantityDefective = quantityDefective;
    }

    @Basic
    @Column(name = "quantity_transit")
    public Integer getQuantityTransit() {
        return quantityTransit;
    }

    public void setQuantityTransit(Integer quantityTransit) {
        this.quantityTransit = quantityTransit;
    }

    @Basic
    @Column(name = "wait_check")
    public Integer getWaitCheck() {
        return waitCheck;
    }

    public void setWaitCheck(Integer waitCheck) {
        this.waitCheck = waitCheck;
    }

    @Basic
    @Column(name = "wait_putaway")
    public Integer getWaitPutaway() {
        return waitPutaway;
    }

    public void setWaitPutaway(Integer waitPutaway) {
        this.waitPutaway = waitPutaway;
    }

    @Basic
    @Column(name = "usable_stock")
    public Integer getUsableStock() {
        return usableStock;
    }

    public void setUsableStock(Integer usableStock) {
        this.usableStock = usableStock;
    }

    @Basic
    @Column(name = "usable_sales")
    public Integer getUsableSales() {
        return usableSales;
    }

    public void setUsableSales(Integer usableSales) {
        this.usableSales = usableSales;
    }

    @Basic
    @Column(name = "usable_sales_private")
    public Integer getUsableSalesPrivate() {
        return usableSalesPrivate;
    }

    public void setUsableSalesPrivate(Integer usableSalesPrivate) {
        this.usableSalesPrivate = usableSalesPrivate;
    }

    @Basic
    @Column(name = "usable_sales_share")
    public Integer getUsableSalesShare() {
        return usableSalesShare;
    }

    public void setUsableSalesShare(Integer usableSalesShare) {
        this.usableSalesShare = usableSalesShare;
    }

    @Basic
    @Column(name = "in_warehouse_share")
    public Integer getInWarehouseShare() {
        return inWarehouseShare;
    }

    public void setInWarehouseShare(Integer inWarehouseShare) {
        this.inWarehouseShare = inWarehouseShare;
    }

    @Basic
    @Column(name = "in_warehouse_private")
    public Integer getInWarehousePrivate() {
        return inWarehousePrivate;
    }

    public void setInWarehousePrivate(Integer inWarehousePrivate) {
        this.inWarehousePrivate = inWarehousePrivate;
    }

    @Basic
    @Column(name = "in_warehouse")
    public Integer getInWarehouse() {
        return inWarehouse;
    }

    public void setInWarehouse(Integer inWarehouse) {
        this.inWarehouse = inWarehouse;
    }

    @Basic
    @Column(name = "occupy_stock_share")
    public Integer getOccupyStockShare() {
        return occupyStockShare;
    }

    public void setOccupyStockShare(Integer occupyStockShare) {
        this.occupyStockShare = occupyStockShare;
    }

    @Basic
    @Column(name = "occupy_stock_private")
    public Integer getOccupyStockPrivate() {
        return occupyStockPrivate;
    }

    public void setOccupyStockPrivate(Integer occupyStockPrivate) {
        this.occupyStockPrivate = occupyStockPrivate;
    }

    @Basic
    @Column(name = "occupy_stock")
    public Integer getOccupyStock() {
        return occupyStock;
    }

    public void setOccupyStock(Integer occupyStock) {
        this.occupyStock = occupyStock;
    }

    @Basic
    @Column(name = "occupy_activity")
    public Integer getOccupyActivity() {
        return occupyActivity;
    }

    public void setOccupyActivity(Integer occupyActivity) {
        this.occupyActivity = occupyActivity;
    }

    @Basic
    @Column(name = "occupy_order_private")
    public Integer getOccupyOrderPrivate() {
        return occupyOrderPrivate;
    }

    public void setOccupyOrderPrivate(Integer occupyOrderPrivate) {
        this.occupyOrderPrivate = occupyOrderPrivate;
    }

    @Basic
    @Column(name = "occupy_order_share")
    public Integer getOccupyOrderShare() {
        return occupyOrderShare;
    }

    public void setOccupyOrderShare(Integer occupyOrderShare) {
        this.occupyOrderShare = occupyOrderShare;
    }

    @Basic
    @Column(name = "occupy_order")
    public Integer getOccupyOrder() {
        return occupyOrder;
    }

    public void setOccupyOrder(Integer occupyOrder) {
        this.occupyOrder = occupyOrder;
    }

    @Basic
    @Column(name = "gmt_create")
    public LocalDateTime getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(LocalDateTime gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    @Basic
    @Column(name = "gmt_modified")
    public LocalDateTime getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(LocalDateTime gmtModified) {
        this.gmtModified = gmtModified;
    }

    @Basic
    @Column(name = "create_time")
    public LocalDateTime getCreateTime() {
        return createTime;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }

    @Basic
    @Column(name = "update_time")
    public LocalDateTime getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(LocalDateTime updateTime) {
        this.updateTime = updateTime;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        DcBaseStock that = (DcBaseStock) o;

        if (id != null ? !id.equals(that.id) : that.id != null) return false;
        if (bailunSku != null ? !bailunSku.equals(that.bailunSku) : that.bailunSku != null) return false;
        if (warehouseCode != null ? !warehouseCode.equals(that.warehouseCode) : that.warehouseCode != null)
            return false;
        if (ownerCode != null ? !ownerCode.equals(that.ownerCode) : that.ownerCode != null) return false;
        if (quantityReservation != null ? !quantityReservation.equals(that.quantityReservation) : that.quantityReservation != null)
            return false;
        if (quantityTransport != null ? !quantityTransport.equals(that.quantityTransport) : that.quantityTransport != null)
            return false;
        if (quantityTransfer != null ? !quantityTransfer.equals(that.quantityTransfer) : that.quantityTransfer != null)
            return false;
        if (quantityFreeze != null ? !quantityFreeze.equals(that.quantityFreeze) : that.quantityFreeze != null)
            return false;
        if (quantitySupplier != null ? !quantitySupplier.equals(that.quantitySupplier) : that.quantitySupplier != null)
            return false;
        if (quantityPresell != null ? !quantityPresell.equals(that.quantityPresell) : that.quantityPresell != null)
            return false;
        if (quantityDefective != null ? !quantityDefective.equals(that.quantityDefective) : that.quantityDefective != null)
            return false;
        if (quantityTransit != null ? !quantityTransit.equals(that.quantityTransit) : that.quantityTransit != null)
            return false;
        if (waitCheck != null ? !waitCheck.equals(that.waitCheck) : that.waitCheck != null) return false;
        if (waitPutaway != null ? !waitPutaway.equals(that.waitPutaway) : that.waitPutaway != null) return false;
        if (usableStock != null ? !usableStock.equals(that.usableStock) : that.usableStock != null) return false;
        if (usableSales != null ? !usableSales.equals(that.usableSales) : that.usableSales != null) return false;
        if (usableSalesPrivate != null ? !usableSalesPrivate.equals(that.usableSalesPrivate) : that.usableSalesPrivate != null)
            return false;
        if (usableSalesShare != null ? !usableSalesShare.equals(that.usableSalesShare) : that.usableSalesShare != null)
            return false;
        if (inWarehouseShare != null ? !inWarehouseShare.equals(that.inWarehouseShare) : that.inWarehouseShare != null)
            return false;
        if (inWarehousePrivate != null ? !inWarehousePrivate.equals(that.inWarehousePrivate) : that.inWarehousePrivate != null)
            return false;
        if (inWarehouse != null ? !inWarehouse.equals(that.inWarehouse) : that.inWarehouse != null) return false;
        if (occupyStockShare != null ? !occupyStockShare.equals(that.occupyStockShare) : that.occupyStockShare != null)
            return false;
        if (occupyStockPrivate != null ? !occupyStockPrivate.equals(that.occupyStockPrivate) : that.occupyStockPrivate != null)
            return false;
        if (occupyStock != null ? !occupyStock.equals(that.occupyStock) : that.occupyStock != null) return false;
        if (occupyActivity != null ? !occupyActivity.equals(that.occupyActivity) : that.occupyActivity != null)
            return false;
        if (occupyOrderPrivate != null ? !occupyOrderPrivate.equals(that.occupyOrderPrivate) : that.occupyOrderPrivate != null)
            return false;
        if (occupyOrderShare != null ? !occupyOrderShare.equals(that.occupyOrderShare) : that.occupyOrderShare != null)
            return false;
        if (occupyOrder != null ? !occupyOrder.equals(that.occupyOrder) : that.occupyOrder != null) return false;
        if (gmtCreate != null ? !gmtCreate.equals(that.gmtCreate) : that.gmtCreate != null) return false;
        if (gmtModified != null ? !gmtModified.equals(that.gmtModified) : that.gmtModified != null) return false;
        if (createTime != null ? !createTime.equals(that.createTime) : that.createTime != null) return false;
        if (updateTime != null ? !updateTime.equals(that.updateTime) : that.updateTime != null) return false;

        return true;
    }

    @Override
    public int hashCode() {
        int result = id != null ? id.hashCode() : 0;
        result = 31 * result + (bailunSku != null ? bailunSku.hashCode() : 0);
        result = 31 * result + (warehouseCode != null ? warehouseCode.hashCode() : 0);
        result = 31 * result + (ownerCode != null ? ownerCode.hashCode() : 0);
        result = 31 * result + (quantityReservation != null ? quantityReservation.hashCode() : 0);
        result = 31 * result + (quantityTransport != null ? quantityTransport.hashCode() : 0);
        result = 31 * result + (quantityTransfer != null ? quantityTransfer.hashCode() : 0);
        result = 31 * result + (quantityFreeze != null ? quantityFreeze.hashCode() : 0);
        result = 31 * result + (quantitySupplier != null ? quantitySupplier.hashCode() : 0);
        result = 31 * result + (quantityPresell != null ? quantityPresell.hashCode() : 0);
        result = 31 * result + (quantityDefective != null ? quantityDefective.hashCode() : 0);
        result = 31 * result + (quantityTransit != null ? quantityTransit.hashCode() : 0);
        result = 31 * result + (waitCheck != null ? waitCheck.hashCode() : 0);
        result = 31 * result + (waitPutaway != null ? waitPutaway.hashCode() : 0);
        result = 31 * result + (usableStock != null ? usableStock.hashCode() : 0);
        result = 31 * result + (usableSales != null ? usableSales.hashCode() : 0);
        result = 31 * result + (usableSalesPrivate != null ? usableSalesPrivate.hashCode() : 0);
        result = 31 * result + (usableSalesShare != null ? usableSalesShare.hashCode() : 0);
        result = 31 * result + (inWarehouseShare != null ? inWarehouseShare.hashCode() : 0);
        result = 31 * result + (inWarehousePrivate != null ? inWarehousePrivate.hashCode() : 0);
        result = 31 * result + (inWarehouse != null ? inWarehouse.hashCode() : 0);
        result = 31 * result + (occupyStockShare != null ? occupyStockShare.hashCode() : 0);
        result = 31 * result + (occupyStockPrivate != null ? occupyStockPrivate.hashCode() : 0);
        result = 31 * result + (occupyStock != null ? occupyStock.hashCode() : 0);
        result = 31 * result + (occupyActivity != null ? occupyActivity.hashCode() : 0);
        result = 31 * result + (occupyOrderPrivate != null ? occupyOrderPrivate.hashCode() : 0);
        result = 31 * result + (occupyOrderShare != null ? occupyOrderShare.hashCode() : 0);
        result = 31 * result + (occupyOrder != null ? occupyOrder.hashCode() : 0);
        result = 31 * result + (gmtCreate != null ? gmtCreate.hashCode() : 0);
        result = 31 * result + (gmtModified != null ? gmtModified.hashCode() : 0);
        result = 31 * result + (createTime != null ? createTime.hashCode() : 0);
        result = 31 * result + (updateTime != null ? updateTime.hashCode() : 0);
        return result;
    }
}
