package com.bailuntec.serviceImpl;

import com.bailuntec.domain.entity.DcLongTermsStorageFee;
import com.bailuntec.domain.entity.DcMonthStorageFee;
import com.bailuntec.domain.enumerate.PlatformType;
import com.bailuntec.mapper.LongTermsStorageFeeMapper;
import com.bailuntec.mapper.MonthStorageFeeMapper;
import com.bailuntec.service.StorageFeeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Pattern;

@Service
@Transactional
public class StorageFeeServiceImpl implements StorageFeeService {
    @Autowired
    private MonthStorageFeeMapper monthStorageFeeMapper;
    @Autowired
    private LongTermsStorageFeeMapper longTermsStorageFeeMapper;

    @Override
    public void analyzeFile(MultipartFile file, HttpServletRequest request) throws Exception {
        DcMonthStorageFee dcMonthStorageFee = new DcMonthStorageFee();
        String name = file.getOriginalFilename();
        String fileName = name.substring(0, name.lastIndexOf("."));
        String[] fileNames = fileName.split("-");
//      accont-sellerId- 文件名格式
        if (fileNames.length > 0) {
            if (fileNames[0] != null) dcMonthStorageFee.setBailunAccount(fileNames[0]);
            if (fileNames[1] != null) dcMonthStorageFee.setSellerId(fileNames[1]);
        }
        InputStream inputStream = file.getInputStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, "gbk"));
        String str = null;
        int n = 0;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM");
        while ((str = reader.readLine()) != null) {
            n++;
            if (n == 1) continue;
            String[] split = str.split("\t");
            if (split.length > 0) {
                if (split[0] != null) dcMonthStorageFee.setAsin(split[0]);
                if (split[1] != null) dcMonthStorageFee.setFnsku(split[1]);
                if (split[2] != null) dcMonthStorageFee.setProductName(split[2]);
                if (split[3] != null) dcMonthStorageFee.setFulfillmentCenter(split[3]);
                if (split[4] != null) dcMonthStorageFee.setCountryCode(split[4]);
                if (split[5] != null) dcMonthStorageFee.setLongestSide(new BigDecimal(split[5]));
                if (split[6] != null) dcMonthStorageFee.setMedianSide(new BigDecimal(split[6]));
                if (split[7] != null) dcMonthStorageFee.setShortestSide(new BigDecimal(split[7]));
                if (split[8] != null) dcMonthStorageFee.setMeasurementUnits(split[8]);
                if (split[9] != null) dcMonthStorageFee.setWeight(new BigDecimal(split[9]));
                if (split[10] != null) dcMonthStorageFee.setWeightUnits(split[10]);
                if (split[11] != null) dcMonthStorageFee.setItemVolume(new BigDecimal(split[11]));
                if (split[12] != null) dcMonthStorageFee.setVolumeUnits(split[12]);
                String regex = ".*[a-zA-Z]+.*";
                if (Pattern.compile(regex).matcher(split[13]).matches()) {
                    if (split[13] != null) dcMonthStorageFee.setSize(split[13]);
                    if (split[14] != null) dcMonthStorageFee.setAverageQuantityOnHand(new BigDecimal(split[14]));
                    if (split[15] != null)
                        dcMonthStorageFee.setAverageQuantityPendingRemoval(new BigDecimal(split[15]));
                    if (split[16] != null) dcMonthStorageFee.setTotalItemVolume(new BigDecimal(split[16]));
                    if (split[17] != null) dcMonthStorageFee.setMonthOfCharge(simpleDateFormat.parse(split[17]));
                    if (split[18] != null) dcMonthStorageFee.setStorageRate(new BigDecimal(split[18]));
                    if (split[19] != null) dcMonthStorageFee.setCurrency(split[19]);
                    if (split[20] != null) dcMonthStorageFee.setMonthlyStorageFee(new BigDecimal(split[20]));
                } else {
                    if (split[13] != null) dcMonthStorageFee.setAverageQuantityOnHand(new BigDecimal(split[13]));
                    if (split[14] != null)
                        dcMonthStorageFee.setAverageQuantityPendingRemoval(new BigDecimal(split[14]));
                    if (split[15] != null) dcMonthStorageFee.setTotalItemVolume(new BigDecimal(split[15]));
                    if (split[16] != null) dcMonthStorageFee.setMonthOfCharge(simpleDateFormat.parse(split[16]));
                    if (split[17] != null) dcMonthStorageFee.setStorageRate(new BigDecimal(split[17]));
                    if (split[18] != null) dcMonthStorageFee.setCurrency(split[18]);
                    if (split[19] != null) dcMonthStorageFee.setMonthlyStorageFee(new BigDecimal(split[19]));
                }
                split = null;
            }
            Date date = new Date();
            dcMonthStorageFee.setCreateTime(date);
            dcMonthStorageFee.setUpdateTime(date);
            dcMonthStorageFee.setPlatform(PlatformType.Amazon.value());
            monthStorageFeeMapper.insertSelective(dcMonthStorageFee);
        }
        if (file != null) file = null;
//        是否要保存文件
//        File dest = new File(path);
//        file.transferTo(dest);
    }

    @Override
    public void analyzeLongTermStorageFile(MultipartFile file, HttpServletRequest request) throws Exception {
        DcLongTermsStorageFee dcLongTermsStorageFee = new DcLongTermsStorageFee();
        String name = file.getOriginalFilename();
        String fileName = name.substring(0, name.lastIndexOf("."));
        String[] fileNames = fileName.split("-");
//      accont-sellerid 文件名格式
        if (fileNames.length > 0) {
            if (fileNames[0] != null) dcLongTermsStorageFee.setBailunAccount(fileNames[0]);
            if (fileNames[1] != null) dcLongTermsStorageFee.setSellerId(fileNames[1]);
        }
        InputStream inputStream = file.getInputStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, "gbk"));
        String str = null;
        int n = 0;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        while ((str = reader.readLine()) != null) {
            n++;
            if (n == 1) continue;
            String[] split = str.split("\t");
            if (split.length > 0) {
                if (split[0] != null) dcLongTermsStorageFee.setSnapshotDate(simpleDateFormat.parse(split[0]));
                if (split[1] != null) dcLongTermsStorageFee.setSku(split[1]);
                if (split[2] != null) dcLongTermsStorageFee.setFnsku(split[2]);
                if (split[3] != null) dcLongTermsStorageFee.setAsin(split[3]);
                if (split[4] != null) dcLongTermsStorageFee.setProductName(split[4]);
                if (split[5] != null) dcLongTermsStorageFee.setProductCondition(split[5]);
                if (split[6] != null) dcLongTermsStorageFee.setQuantityGt12Month(new BigDecimal(split[6]));
                if (split[7] != null) dcLongTermsStorageFee.setPerUnitVolume(new BigDecimal(split[7]));
                if (split[8] != null) dcLongTermsStorageFee.setCurrency(split[8]);
                if (split[9] != null) dcLongTermsStorageFee.setStorageFeeGt12Month(new BigDecimal(split[9]));
                if (split[10] != null) dcLongTermsStorageFee.setQuantityGt6Month(new BigDecimal(split[10]));
                if (split[11] != null) dcLongTermsStorageFee.setStorageFeeGt6Month(new BigDecimal(split[11]));
                if (split[12] != null) dcLongTermsStorageFee.setVolumeUnit(split[12]);
                if (split[13] != null) dcLongTermsStorageFee.setCountry(split[13]);
                if (split[14] != null) dcLongTermsStorageFee.setSmallAndLight(split[14]);
                split = null;
            }
            Date date = new Date();
            dcLongTermsStorageFee.setGmtCreate(date);
            dcLongTermsStorageFee.setGmtModified(date);
            dcLongTermsStorageFee.setPlatform(PlatformType.Amazon.value());
            longTermsStorageFeeMapper.insertSelective(dcLongTermsStorageFee);
        }
        if (file != null) file = null;
    }
}
