package com.bailuntec.domain.enumerate;

public enum CurrencyType {
    AFA(0, "AFA"),
    ALL(1, "ALL"),
    DZD(2, "DZD"),
    ADP(3, "ADP"),
    AOA(4, "AOA"),
    ARS(5, "ARS"),
    AMD(6, "AMD"),
    AWG(7, "AWG"),
    AZM(8, "AZM"),
    BSD(9, "BSD"),
    BHD(10, "BHD"),
    BDT(11, "BDT"),
    BBD(12, "BBD"),
    BYR(13, "BYR"),
    BZD(14, "BZD"),
    BMD(15, "BMD"),
    BTN(16, "BTN"),
    INR(17, "INR"),
    BOV(18, "BOV"),
    BOB(19, "BOB"),
    BAM(20, "BAM"),
    BWP(21, "BWP"),
    BRL(22, "BRL"),
    BND(23, "BND"),
    BGL(24, "BGL"),
    BGN(25, "BGN"),
    BIF(26, "BIF"),
    KHR(27, "KHR"),
    CAD(28, "CAD"),
    CVE(29, "CVE"),
    KYD(30, "KYD"),
    XAF(31, "XAF"),
    CLF(32, "CLF"),
    CLP(33, "CLP"),
    CNY(34, "CNY"),
    COP(35, "COP"),
    KMF(36, "KMF"),
    CDF(37, "CDF"),
    CRC(38, "CRC"),
    HRK(39, "HRK"),
    CUP(40, "CUP"),
    CYP(41, "CYP"),
    CZK(42, "CZK"),
    DKK(43, "DKK"),
    DJF(44, "DJF"),
    DOP(45, "DOP"),
    TPE(46, "TPE"),
    ECV(47, "ECV"),
    ECS(48, "ECS"),
    EGP(49, "EGP"),
    SVC(50, "SVC"),
    ERN(51, "ERN"),
    EEK(52, "EEK"),
    ETB(53, "ETB"),
    FKP(54, "FKP"),
    FJD(55, "FJD"),
    GMD(56, "GMD"),
    GEL(57, "GEL"),
    GHC(58, "GHC"),
    GIP(59, "GIP"),
    GTQ(60, "GTQ"),
    GNF(61, "GNF"),
    GWP(62, "GWP"),
    GYD(63, "GYD"),
    HTG(64, "HTG"),
    HNL(65, "HNL"),
    HKD(66, "HKD"),
    HUF(67, "HUF"),
    ISK(68, "ISK"),
    IDR(69, "IDR"),
    IRR(70, "IRR"),
    IQD(71, "IQD"),
    ILS(72, "ILS"),
    JMD(73, "JMD"),
    JPY(74, "JPY"),
    JOD(75, "JOD"),
    KZT(76, "KZT"),
    KES(77, "KES"),
    AUD(78, "AUD"),
    KPW(79, "KPW"),
    KRW(80, "KRW"),
    KWD(81, "KWD"),
    KGS(82, "KGS"),
    LAK(83, "LAK"),
    LVL(84, "LVL"),
    LBP(85, "LBP"),
    LSL(86, "LSL"),
    LRD(87, "LRD"),
    LYD(88, "LYD"),
    CHF(89, "CHF"),
    LTL(90, "LTL"),
    MOP(91, "MOP"),
    MKD(92, "MKD"),
    MGF(93, "MGF"),
    MWK(94, "MWK"),
    MYR(95, "MYR"),
    MVR(96, "MVR"),
    MTL(97, "MTL"),
    EUR(98, "EUR"),
    MRO(99, "MRO"),
    MUR(100, "MUR"),
    MXN(101, "MXN"),
    MXV(102, "MXV"),
    MDL(103, "MDL"),
    MNT(104, "MNT"),
    XCD(105, "XCD"),
    MZM(106, "MZM"),
    MMK(107, "MMK"),
    ZAR(108, "ZAR"),
    NAD(109, "NAD"),
    NPR(110, "NPR"),
    ANG(111, "ANG"),
    XPF(112, "XPF"),
    NZD(113, "NZD"),
    NIO(114, "NIO"),
    NGN(115, "NGN"),
    NOK(116, "NOK"),
    OMR(117, "OMR"),
    PKR(118, "PKR"),
    PAB(119, "PAB"),
    PGK(120, "PGK"),
    PYG(121, "PYG"),
    PEN(122, "PEN"),
    PHP(123, "PHP"),
    PLN(124, "PLN"),
    USD(125, "USD"),
    QAR(126, "QAR"),
    ROL(127, "ROL"),
    RUB(128, "RUB"),
    RUR(129, "RUR"),
    RWF(130, "RWF"),
    SHP(131, "SHP"),
    WST(132, "WST"),
    STD(133, "STD"),
    SAR(134, "SAR"),
    SCR(135, "SCR"),
    SLL(136, "SLL"),
    SGD(137, "SGD"),
    SKK(138, "SKK"),
    SIT(139, "SIT"),
    SBD(140, "SBD"),
    SOS(141, "SOS"),
    LKR(142, "LKR"),
    SDD(143, "SDD"),
    SRG(144, "SRG"),
    SZL(145, "SZL"),
    SEK(146, "SEK"),
    SYP(147, "SYP"),
    TWD(148, "TWD"),
    TJS(149, "TJS"),
    TZS(150, "TZS"),
    THB(151, "THB"),
    XOF(152, "XOF"),
    TOP(153, "TOP"),
    TTD(154, "TTD"),
    TND(155, "TND"),
    TRY(156, "TRY"),
    TMM(157, "TMM"),
    UGX(158, "UGX"),
    UAH(159, "UAH"),
    AED(160, "AED"),
    GBP(161, "GBP"),
    USS(162, "USS"),
    USN(163, "USN"),
    UYU(164, "UYU"),
    UZS(165, "UZS"),
    VUV(166, "VUV"),
    VEB(167, "VEB"),
    VND(168, "VND"),
    MAD(169, "MAD"),
    YER(170,"YER"),
    YUM(171, "YUM"),
    ZMK(172, "ZMK"),
    ZWD(173, "ZWD"),
    CUSTOMCODE(174, "CustomCode");

    private final Integer code;
    private final String value;

    CurrencyType(Integer code, String value) {
        this.code = code;
        this.value = value;
    }

    public Integer code() {
        return code;
    }

    public String value() {
        return value;
    }

    public static String getVal(Integer code) {
        CurrencyType [] currencyTypes = values();
        for(CurrencyType currencyType : currencyTypes) {
            if(currencyType.code().equals(code)) {
                return currencyType.value();
            }
        }
        return null;
    }

    public static Integer getKey(String value) {
        CurrencyType [] currencyTypes = values();
        for(CurrencyType currencyType : currencyTypes) {
            if(currencyType.value().equals(value)) {
                return currencyType.code();
            }
        }
        return null;
    }
}
