package com.bailuntec.job;


import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.bailuntec.domain.AdvertResultData;
import com.bailuntec.domain.AdvertResultInfo;
import com.bailuntec.domain.AmazonAdvert;
import com.bailuntec.domain.entity.JobAccountLog;
import com.bailuntec.domain.entity.JobPointLog;
import com.bailuntec.domain.enumerate.AccountPlatformType;
import com.bailuntec.domain.example.DcBaseCompanyAccountExample;
import com.bailuntec.mapper.DcBaseFinanceAmazonMapper;
import com.bailuntec.mapper.DcBaseCompanyAccountMapper;
import com.bailuntec.mapper.JobAccountLogMapper;
import com.bailuntec.support.PointJob;
import com.bailuntec.utils.OkHttpUtil;
import com.bailuntec.utils.PropertiesUtil;
import com.bailuntec.utils.SessionUtil;
import com.dangdang.ddframe.job.api.ShardingContext;
import lombok.extern.slf4j.Slf4j;
import okhttp3.*;
import org.apache.commons.lang3.StringUtils;

import java.util.HashMap;
import java.util.List;

@Slf4j
public class AdvertResultSyncJob extends PointJob {

    private PropertiesUtil propertiesUtil = PropertiesUtil.getInstance("const");
    private OkHttpClient client = OkHttpUtil.getInstance();

    @Override
    public void executeJob(ShardingContext shardingContext, JobPointLog jobPointLog) {
       /* int totalPage = getCount(jobPointLog);//分片即将处理的账号总数
        try {
            JobAccountLogMapper jobAccountLogMapper = SessionUtil.getSession().getMapper(JobAccountLogMapper.class);
            int pageSize = totalPage % shardingContext.getShardingTotalCount() == 0 ? totalPage / shardingContext.getShardingTotalCount() : totalPage / shardingContext.getShardingTotalCount() + 1;
            List<JobAccountLog> listByPage = jobAccountLogMapper.getListByPage(AccountPlatformType.Amazon.code(), pageSize * shardingContext.getShardingItem(), pageSize);
            for (JobAccountLog jobAccountLog : listByPage) {
                String taskIds = jobAccountLog.getTaskIds();
                if(StringUtils.isNotBlank(taskIds)) {
                    List<List<Integer>> taskIdsList = (List<List<Integer>>) JSONArray.parse(taskIds);
                    for (List<Integer> ids : taskIdsList) {
                        callSaasApi(jobAccountLog, ids);
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
            log.warn("Amazon广告费接口调用错误", e);
        } finally {
            SessionUtil.closeSession();
        }*/
    }
/*
    private int getCount(JobPointLog jobPointLog) {
        int i = 0;
        try {
            DcBaseCompanyAccountMapper accountMapper = SessionUtil.getSession().getMapper(DcBaseCompanyAccountMapper.class);
            i = (int) accountMapper.countByExample(DcBaseCompanyAccountExample.newAndCreateCriteria().andPlatformIdEqualTo(AccountPlatformType.Amazon.code()).example());
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            SessionUtil.closeSession();
        }
        return i;
    }

    public void callSaasApi(JobAccountLog job, List<Integer> ids) {
        HashMap<String, Object> map = new HashMap<>(2);
        map.put("app_id", 1);
        map.put("task_ids", ids);
        MediaType mediaType = MediaType.parse("application/json");
        Response response = null;
        try {
            DcBaseFinanceAmazonMapper dcBaseFinanceAmazonMapper = SessionUtil.getSession().getMapper(DcBaseFinanceAmazonMapper.class);

            RequestBody body = RequestBody.create(mediaType, JSON.toJSONString(map));
            Request request = new Request.Builder()
                    .url(propertiesUtil.getPropertyAsString("GETRESULT_FINANCE_URL"))
                    .post(body)
                    .addHeader("Content-Type", "application/json")
                    .build();
            response = client.newCall(request).execute();
            if (response.isSuccessful()) {
                AdvertResultInfo advertResult = JSON.parseObject(response.body().string(), AdvertResultInfo.class);
                if (advertResult != null && advertResult.getCode() == 0) {
                    List<AdvertResultData> accountEntries = advertResult.getResults();
                    if (accountEntries != null && accountEntries.size() > 0) {
                        List<AmazonAdvert> advertList = JSON.parseArray(accountEntries.get(0).getData().get(0), AmazonAdvert.class);
                        for (AmazonAdvert amazonAdvert : advertList) {
                            amazonAdvert.setAccountId(job.getAccountId());
                            amazonAdvert.setCompanyId(job.getCompanyId());
                            dcBaseFinanceAmazonMapper.upsertSelective(amazonAdvert);
                        }
                    }
                } else {
                    throw new RuntimeException("授权错误");
                }
            } else {
                throw new RuntimeException("接口调用失败");
            }
        } catch (Exception e) {
            job.setMessage(e.getMessage());
        } finally {
            if (response != null) {
                response.close();
            }
        }
    }*/
}
