package com.bailuntec.domain.entity;

import javax.persistence.*;
import java.time.LocalDateTime;

@Entity
@Table(name = "dc_mid_transit", schema = "bailun_datacenter")
public class DcMidTransit {
    private Integer id;
    private String bailunSku;
    private String warehouseCode;
    private Integer quantityPurchase;
    private LocalDateTime gmtPurchaseModified;
    private Integer quantityTransfer;
    private LocalDateTime gmtTransferModified;
    private Integer quantityOutStock;
    private LocalDateTime gmtOutStockModified;

    @Id
    @Column(name = "id")
    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @Basic
    @Column(name = "bailun_sku")
    public String getBailunSku() {
        return bailunSku;
    }

    public void setBailunSku(String bailunSku) {
        this.bailunSku = bailunSku;
    }

    @Basic
    @Column(name = "warehouse_code")
    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    @Basic
    @Column(name = "quantity_purchase")
    public Integer getQuantityPurchase() {
        return quantityPurchase;
    }

    public void setQuantityPurchase(Integer quantityPurchase) {
        this.quantityPurchase = quantityPurchase;
    }

    @Basic
    @Column(name = "gmt_purchase_modified")
    public LocalDateTime getGmtPurchaseModified() {
        return gmtPurchaseModified;
    }

    public void setGmtPurchaseModified(LocalDateTime gmtPurchaseModified) {
        this.gmtPurchaseModified = gmtPurchaseModified;
    }

    @Basic
    @Column(name = "quantity_transfer")
    public Integer getQuantityTransfer() {
        return quantityTransfer;
    }

    public void setQuantityTransfer(Integer quantityTransfer) {
        this.quantityTransfer = quantityTransfer;
    }

    @Basic
    @Column(name = "gmt_transfer_modified")
    public LocalDateTime getGmtTransferModified() {
        return gmtTransferModified;
    }

    public void setGmtTransferModified(LocalDateTime gmtTransferModified) {
        this.gmtTransferModified = gmtTransferModified;
    }

    @Basic
    @Column(name = "quantity_out_stock")
    public Integer getQuantityOutStock() {
        return quantityOutStock;
    }

    public void setQuantityOutStock(Integer quantityOutStock) {
        this.quantityOutStock = quantityOutStock;
    }

    @Basic
    @Column(name = "gmt_out_stock_modified")
    public LocalDateTime getGmtOutStockModified() {
        return gmtOutStockModified;
    }

    public void setGmtOutStockModified(LocalDateTime gmtOutStockModified) {
        this.gmtOutStockModified = gmtOutStockModified;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        DcMidTransit that = (DcMidTransit) o;

        if (id != null ? !id.equals(that.id) : that.id != null) return false;
        if (bailunSku != null ? !bailunSku.equals(that.bailunSku) : that.bailunSku != null) return false;
        if (warehouseCode != null ? !warehouseCode.equals(that.warehouseCode) : that.warehouseCode != null)
            return false;
        if (quantityPurchase != null ? !quantityPurchase.equals(that.quantityPurchase) : that.quantityPurchase != null)
            return false;
        if (gmtPurchaseModified != null ? !gmtPurchaseModified.equals(that.gmtPurchaseModified) : that.gmtPurchaseModified != null)
            return false;
        if (quantityTransfer != null ? !quantityTransfer.equals(that.quantityTransfer) : that.quantityTransfer != null)
            return false;
        if (gmtTransferModified != null ? !gmtTransferModified.equals(that.gmtTransferModified) : that.gmtTransferModified != null)
            return false;
        if (quantityOutStock != null ? !quantityOutStock.equals(that.quantityOutStock) : that.quantityOutStock != null)
            return false;
        if (gmtOutStockModified != null ? !gmtOutStockModified.equals(that.gmtOutStockModified) : that.gmtOutStockModified != null)
            return false;

        return true;
    }

    @Override
    public int hashCode() {
        int result = id != null ? id.hashCode() : 0;
        result = 31 * result + (bailunSku != null ? bailunSku.hashCode() : 0);
        result = 31 * result + (warehouseCode != null ? warehouseCode.hashCode() : 0);
        result = 31 * result + (quantityPurchase != null ? quantityPurchase.hashCode() : 0);
        result = 31 * result + (gmtPurchaseModified != null ? gmtPurchaseModified.hashCode() : 0);
        result = 31 * result + (quantityTransfer != null ? quantityTransfer.hashCode() : 0);
        result = 31 * result + (gmtTransferModified != null ? gmtTransferModified.hashCode() : 0);
        result = 31 * result + (quantityOutStock != null ? quantityOutStock.hashCode() : 0);
        result = 31 * result + (gmtOutStockModified != null ? gmtOutStockModified.hashCode() : 0);
        return result;
    }
}
