package com.bailuntec.ebay_uk_report.service;

import com.bailuntec.ebay_uk_report.mapper.DcEbayReportUkMapper;
import com.bailuntec.ebay_uk_report.util.DateTimeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

import java.util.Date;

@Service
public class EbayUkReportService {

    @Autowired
    private DcEbayReportUkMapper dcEbayReportUkMapper;

    private static Logger logger = LoggerFactory.getLogger(EbayUkReportService.class);

    @Scheduled(cron = "0 0 0 * * *") // 每天凌晨0点运行一次
    public void generateReport() {
        Date today = DateTimeUtil.getCurrentDay();
        Date lastDay = DateTimeUtil.getCurrentLastDay();
        Date twoDaysAgo = DateTimeUtil.addDays(lastDay, -1);
        dcEbayReportUkMapper.insertReport(twoDaysAgo, lastDay, today);
    }

}
