package com.bailuntec.job;

import com.bailuntec.domain.entity.DcBaseStock;
import com.bailuntec.mapper.DcBaseStockMapper;
import com.bailuntec.utils.SessionUtil;
import com.dangdang.ddframe.job.api.ShardingContext;
import com.dangdang.ddframe.job.api.simple.SimpleJob;
import lombok.extern.slf4j.Slf4j;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

@Slf4j
public class DailyStockJob implements SimpleJob {
    @Override
    public void execute(ShardingContext shardingContext) {
        try {
            DcBaseStockMapper mapper = SessionUtil.getSession().getMapper(DcBaseStockMapper.class);
            List<DcBaseStock> dcBaseStockList = mapper.selectStock();
            mapper.insertDailyStock(dcBaseStockList);
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("MYBATIS操作DB失败", e);
        } finally {
            SessionUtil.closeSession();
        }
    }
}
