package com.bailuntec.balancesheet.mapper;

import com.bailuntec.balancesheet.dto.WithdrawOnWayDTO;
import org.apache.ibatis.annotations.*;
import org.springframework.stereotype.Repository;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@Repository
public interface DcWithdrawOnWayMapper {
    @Insert("<script>" +
            "insert into dc_withdraw_on_way(sale_platform_id,sale_platform,platform_id,platform,pay_account_id,pay_account,bank_name,bank_card_user,amount_rmb,statistical_time) values " +
            "<foreach collection='list' item='item' index='index' separator=','>" +
            "(#{item.salePlatformId},#{item.salePlatform},#{item.platformId},#{item.platform},#{item.payAccountId},#{item.payAccount}," +
            "#{item.bankName},#{item.bankCardUser},#{item.amountRmb},#{lastDay})" +
            "</foreach>" +
            "</script>")
    void insertWithdrawOnWay(@Param("list") List<WithdrawOnWayDTO> withdrawOnWayDTOList, @Param("lastDay") Date lastDay);

    @Update("update dc_withdraw_on_way w inner join dc_bank_account_balance b on w.pay_account_id = b.pay_account_id and w.statistical_time = b.statistical_time " +
            "set w.company_value = b.company_value")
    void updateWithdrawOnWayCompany();


    @Select("select sum(amount_rmb) from dc_withdraw_on_way where statistical_time = #{lastDay}")
    BigDecimal getWithdrawOnWaySum(@Param("lastDay") Date lastDay);

}
