package com.bailuntec.balancesheet.controller;

import com.alibaba.fastjson.JSONObject;
import com.bailuntec.balancesheet.dto.LogisticsSupplierTransactionDTO;
import com.bailuntec.balancesheet.dto.SupplierTransactionDTO;
import com.bailuntec.balancesheet.service.BalanceSheetService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@RestController
public class BalanceSheetController {
    @Autowired
    private BalanceSheetService balanceSheetService;

    private  static Logger logger = LoggerFactory.getLogger(BalanceSheetController.class);

    @GetMapping("/generate")
    public String doScheduledTask(){
        try{
            balanceSheetService.doScheduledTask0000();
        }catch (Exception e){
            e.printStackTrace();
            logger.error(">>>>>生成资产负债表出错" + e.getMessage());
            return "生成资产负债表出错";
        }
        return "生成资产负债表成功";
    }

    @GetMapping("/test")
    public String test(){
        return "OK";
    }

    /**
     * 更新调整后的供应商往来数据：应付账款和预付账款
     * @return
     */
    @PostMapping("/adjustSupplierTransaction")
    public String adjustSupplierTransaction(@RequestBody String updateData){
        JSONObject result = new JSONObject();
        try{
            List<SupplierTransactionDTO> supplierTransactionDTOList = JSONObject.parseArray(updateData, SupplierTransactionDTO.class);
            if(supplierTransactionDTOList != null && supplierTransactionDTOList.size() > 0){
                balanceSheetService.adjustSupplierTransaction(supplierTransactionDTOList);
            }
            result.put("success", true);
            result.put("message", "success");
        } catch (Exception e){
            e.printStackTrace();
            logger.error(">>>>>更新调整后的供应商往来数据失败" + e.getMessage());
            result.put("success", false);
            result.put("message", "更新调整后的供应商往来数据失败" + e.getMessage());
        }
        return result.toString();
    }

    /**
     * 更新调整后的物流供应商往来数据：应付账款和预付账款
     * @return
     */
    @PostMapping("/adjustLogisticsSupplierTransaction")
    public String adjustLogisticsSupplierTransaction(@RequestBody String updateData){
        JSONObject result = new JSONObject();
        try{
            List<LogisticsSupplierTransactionDTO> logisticsSupplierTransactionDTOList = JSONObject.parseArray(updateData, LogisticsSupplierTransactionDTO.class);
            if(logisticsSupplierTransactionDTOList != null && logisticsSupplierTransactionDTOList.size() > 0){
                balanceSheetService.adjustLogisticsSupplierTransaction(logisticsSupplierTransactionDTOList);
            }
            result.put("success", true);
            result.put("message", "success");
        } catch (Exception e){
            e.printStackTrace();
            logger.error(">>>>>更新调整后的物流供应商往来数据失败" + e.getMessage());
            result.put("success", false);
            result.put("message", "更新调整后的物流供应商往来数据失败" + e.getMessage());
        }
        return result.toString();
    }

}
