package com.bailuntec.utils;

import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

public class RedisUtil {
    private final static PropertiesUtil propertiesUtil = PropertiesUtil.getInstance("redis");
    private static JedisPool jedisPool;

    private RedisUtil() {
    }

    public static Jedis getResource() {
        synchronized (RedisUtil.class) {
            if (jedisPool == null) {
                jedisPool = new JedisPool(propertiesUtil.getPropertyAsString("host"), propertiesUtil.getPropertyAsInt("port"));
            }
            return  jedisPool.getResource();
        }
    }

    public static void destory() {
        synchronized (RedisUtil.class) {
            if (jedisPool != null) {
                jedisPool.destroy();
            }
        }
    }
}
