package com.bailuntec.domain.pojo;

import lombok.Data;

import java.util.Date;

@Data
public class SkuMappingInfo {
    /// <summary>
    /// 返回数据类型，1正常，2分页，99导出
    /// </summary>
    public Integer resultType;

    /// <summary>
    /// 页数
    /// </summary>
    public Integer page;

    /// <summary>
    /// 分页大小，最大1000
    /// </summary>
    public Integer pageSize;

    /// <summary>
    /// 排序列
    /// </summary>
    public String sortField;

    /// <summary>
    /// 排序方式
    /// </summary>
    public String sort;

    /// <summary>
    /// 主键
    /// </summary>
    public Integer id;

    /// <summary>
    /// 平台Id
    /// </summary>
    public Integer platId;

    /// <summary>
    /// 平台
    /// </summary>
    public String plat;

    /// <summary>
    /// 站点Id
    /// </summary>
    public Integer siteId;

    /// <summary>
    /// 站点
    /// </summary>
    public String site;

    /// <summary>
    /// 帐号Id
    /// </summary>
    public Integer accountId;

    /// <summary>
    /// 登录帐号
    /// </summary>
    public String loginAccount;

    /// <summary>
    /// 帐号
    /// </summary>
    public String account;

    /// <summary>
    /// 销售
    /// </summary>
    public String sellerName;

    /// <summary>
    /// 刊登商品编码
    /// </summary>
    public String platProduct;

    /// <summary>
    /// ItemId
    /// </summary>
    public String itemId;

    /// <summary>
    /// ItemUrl
    /// </summary>
    public String ItemUrl;

    /// <summary>
    /// 查询类型 1 平台SKU 2产品库SKU 3中文名称
    /// </summary>
    public Integer searchType;

    /// <summary>
    /// 查询值
    /// </summary>
    public String search;

    /// <summary>
    /// 平台SKU
    /// </summary>
    public String platSku;

    /// <summary>
    /// 产品库SKU
    /// </summary>
    public String sku;

    /// <summary>
    /// 中文名称
    /// </summary>
    public String title;

    /// <summary>
    /// 数量
    /// </summary>
    public Integer count;

    /// <summary>
    /// 内部商品编码
    /// </summary>
    public String goodsCode;

    /// <summary>
    /// 内部产品编码
    /// </summary>
    public String productCode;

    /// <summary>
    /// 商品表Id
    /// </summary>
    public Integer mainId;

    /// <summary>
    /// skuid
    /// </summary>
    public Integer sId;

    /// <summary>
    /// 商品编码
    /// </summary>
    public String product;

    /// <summary>
    /// 组合关系
    /// </summary>
    public String groupRelete;

    /// <summary>
    /// 一级分类
    /// </summary>
    public Integer firCate;

    /// <summary>
    /// 二级分类
    /// </summary>
    public Integer secCate;

    /// <summary>
    /// 平台分类全名
    /// </summary>
    public String fullName;

    /// <summary>
    /// 属性类型
    /// </summary>
    public String attrType;

    /// <summary>
    /// 是否组合
    /// </summary>
    public String isGroup;

    /// <summary>
    /// 是否任意SKU
    /// </summary>
    public String isAny;

    /// <summary>
    /// 是否映射完成
    /// </summary>
    public String isMap;

    /// <summary>
    /// 是否上传
    /// </summary>
    public String isUpApi;

    /// <summary>
    /// 数据来源 1在线listting,2订单,3刊登,4, 手工添加
    /// </summary>
    public String source;

    /// <summary>
    /// 失败原因
    /// </summary>
    public String errorMsg;

    /// <summary>
    /// 创建人
    /// </summary>
    public String createUser;

    /// <summary>
    /// 创建时间
    /// </summary>
    public Date createTime;


}
