package com.bailuntec.job;

import com.bailuntec.utils.OkHttpUtil;
import com.bailuntec.utils.PropertiesUtil;
import com.dangdang.ddframe.job.api.ShardingContext;
import com.dangdang.ddframe.job.api.simple.SimpleJob;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

import java.io.IOException;

public class SkuWarehouseRedundancyJob implements SimpleJob {
    private OkHttpClient client = OkHttpUtil.getInstance();
    private PropertiesUtil propertiesUtil = PropertiesUtil.getInstance("const");
    @Override
    public void execute(ShardingContext shardingContext) {
        RequestBody requestBody = RequestBody.create(null, new byte[]{});
        Request request = new Request.Builder().url(propertiesUtil.getPropertyAsString("SKUWAREHOUSEREDUNDANCY_URL"))
                .post(requestBody)
                .addHeader("Content-Type", "application/json")
                .build();
        Response response = null;
        try {
            response = client.newCall(request).execute();
        } catch (IOException e) {
            throw new RuntimeException("调用SkuWarehouseRedundancy接口失败", e);
        } finally {
            if (response != null) {
                response.close();
            }
        }
    }
}
