package com.bailuntec.job;

import com.alibaba.fastjson.JSON;
import com.bailuntec.domain.entity.DcBaseBailuncategory;
import com.bailuntec.domain.example.DcBaseBailuncategoryExample;
import com.bailuntec.domain.pojo.BailunCategoryResult;
import com.bailuntec.mapper.DcBaseBailuncategoryMapper;
import com.bailuntec.utils.OkHttpUtil;
import com.bailuntec.utils.PropertiesUtil;
import com.bailuntec.utils.SessionUtil;
import com.dangdang.ddframe.job.api.ShardingContext;
import com.dangdang.ddframe.job.api.simple.SimpleJob;
import lombok.extern.slf4j.Slf4j;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.beanutils.BeanUtils;

import java.time.LocalDateTime;
import java.util.LinkedHashMap;

@Slf4j
public class BailunCategoryJob implements SimpleJob {
    private PropertiesUtil propertiesUtil = PropertiesUtil.getInstance("const");
    private OkHttpClient client = OkHttpUtil.getInstance();
    @Override
    public void execute(ShardingContext shardingContext) {
        LinkedHashMap<String, String> map = new LinkedHashMap<>(2);
        map.put("level", "0");
        Request request = new Request.Builder()
                .url(OkHttpUtil.attachHttpGetParams(propertiesUtil.getPropertyAsString("BAILUN_CATEGORY_URL"), map))
                .get()
                .addHeader("Content-Type", "application/json")
                .build();
        Response response  = null;
        try {
            response  = client.newCall(request).execute();
            BailunCategoryResult bailunCategoryResult = JSON.parseObject(response.body().byteStream(), BailunCategoryResult.class);
            if (bailunCategoryResult.getStatusCode().equals(200)) {
                if (bailunCategoryResult.getResult() != null && bailunCategoryResult.getResult().size() > 0) {
                    DcBaseBailuncategory dcBaseBailuncategory = new DcBaseBailuncategory();
                    DcBaseBailuncategoryMapper mapper = SessionUtil.getSession().getMapper(DcBaseBailuncategoryMapper.class);
                        LocalDateTime startTime = LocalDateTime.now();
                    for (DcBaseBailuncategory baseBailuncategory : bailunCategoryResult.getResult()) {
                        try {
                            BeanUtils.copyProperties(dcBaseBailuncategory, baseBailuncategory);
                        } catch (Exception e) {
                            throw  new RuntimeException("BeanUtils.copyProperties失败",e);
                        }
                        if(dcBaseBailuncategory.getCName() != null && dcBaseBailuncategory.getCName().contains("New")) {
                            dcBaseBailuncategory.setGmtModified(startTime);
                            mapper.upsertSelective(dcBaseBailuncategory);
                        }
                        mapper.deleteByExample(DcBaseBailuncategoryExample.newAndCreateCriteria().andGmtModifiedLessThan(startTime.minusHours(1L)).example());
                    }
                }
            } else {
                throw  new RuntimeException("调用百伦分类接口返回错误");
            }
        } catch (Exception e) {
           throw new RuntimeException("调用百伦分类接口失败" + e.getCause().getMessage(), e);
        } finally {
            SessionUtil.closeSession();
            if (response != null) {
                response.close();
            }
        }
    }
}
