package com.bailuntec.balancesheet.mapper;


import com.bailuntec.balancesheet.dto.SellerAccountDTO;
import org.apache.ibatis.annotations.Insert;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface DcBaseSellerAccountMapper {

    @Insert("<script>" +
            "insert into dc_base_seller_account (account,email_account,oms_code,oms_account,platform_id,platform,platform_en,site_id,site,site_en,auth_json,status," +
            "status_cn,soap_auth_token,soap_auth_status,auth_status,extension_info,developer_json,manager,seller_id) values " +
            "<foreach collection='list' item='item' index='index' separator=','>" +
            "(#{item.account},#{item.emailAccount},#{item.omsCode},#{item.omsAccount},#{item.platformId},#{item.platform},#{item.platformEn},#{item.siteId},#{item.site}," +
            "#{item.siteEn},#{item.authJson},#{item.status},#{item.statusCn},#{item.soapAuthToken},#{item.soapAuthStatus},#{item.authStatus},#{item.extensionInfo}," +
            "#{item.developerJson},#{item.manager},#{item.sellerId})" +
            "</foreach>" +
            "on duplicate key update email_account = values (email_account),oms_code = values (oms_code), oms_account = values (oms_account),platform_id = values (platform_id)," +
            "platform = values (platform),platform_en = values (platform_en),site_id = values (site_id),site = values (site),site_en = values (site_en)," +
            "auth_json = values (auth_json),status = values (status),status_cn = values (status_cn),soap_auth_token = values (soap_auth_token)," +
            "soap_auth_status = values (soap_auth_status),auth_status = values (auth_status),extension_info = values (extension_info),developer_json = values (developer_json)," +
            "manager = values (manager),seller_id = values (seller_id)" +
            "</script>")
    Integer insertOrUpdateSellerAccount(List<SellerAccountDTO> list);

}