package com.bailuntec.job;

import com.bailuntec.mapper.DcBaseStockMapper;
import com.bailuntec.utils.SessionUtil;
import com.dangdang.ddframe.job.api.ShardingContext;
import com.dangdang.ddframe.job.api.simple.SimpleJob;

public class AutoTurnoverPrepareJob implements SimpleJob {
    /**
     * 自动周转基于库存计算.
     * 但是新品SKU不会有库存, 也要参与计算
     * 所以从订单, 采购系统, SKUMS拿到新品SKU, 插入库存表
     * @param shardingContext
     */
    @Override
    public void execute(ShardingContext shardingContext) {
        try {
            DcBaseStockMapper mapper = SessionUtil.getSession().getMapper(DcBaseStockMapper.class);
            mapper.supplementOrderSku();
            mapper.supplementPurchaseSku();
            mapper.supplementSkumsSku();
            mapper.supplementTransitSku();
//            mapper.deleteStopSellingSku();
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("MYBATIS操作DB失败",e);
        } finally {
            SessionUtil.closeSession();
        }

    }
}
