import com.bailuntec.domain.entity.DcBaseCompanyAccount;
import com.bailuntec.domain.entity.JobAccountLog;
import com.bailuntec.domain.entity.JobPointLog;
import com.bailuntec.domain.example.DcBaseCompanyAccountExample;
import com.bailuntec.domain.example.JobAccountLogExample;
import com.bailuntec.job.AmazonAdProductJob;
import com.bailuntec.mapper.DcBaseCompanyAccountMapper;
import com.bailuntec.mapper.JobAccountLogMapper;
import com.bailuntec.utils.SessionUtil;
import com.dangdang.ddframe.job.api.ShardingContext;
import com.dangdang.ddframe.job.executor.ShardingContexts;
import org.junit.jupiter.api.Test;

import java.time.LocalDateTime;
import java.util.HashMap;

public class AmazonAdProductTest {

    @Test
    public void test() {
        AmazonAdProductJob amazonAdProductJob = new AmazonAdProductJob();
        ShardingContexts shardingContexts = new ShardingContexts(null,"base-sync-finance-amazon-ad-product",1,null,new HashMap<>());
        ShardingContext shardingContext = new ShardingContext(shardingContexts,0);
        JobPointLog jobPointLog = new JobPointLog("base-sync-finance-amazon-ad-product", 1, 100, 0, 1,
                LocalDateTime.of(2019, 7, 1, 0, 0),
                LocalDateTime.of(2019, 7, 2, 0, 0));
        amazonAdProductJob.executeJob(shardingContext, jobPointLog);
    }
    @Test
    public void test1() {
        AmazonAdProductJob amazonAdProductJob = new AmazonAdProductJob();
        JobAccountLogMapper mapper = SessionUtil.getSession().getMapper(JobAccountLogMapper.class);
        JobAccountLog dcBaseCompanyAccount = mapper.selectOneByExample(JobAccountLogExample.newAndCreateCriteria().andAccountIdEqualTo(591).example());
        amazonAdProductJob.callAmazonAdApi(dcBaseCompanyAccount);
    }
}
