package com.bailuntec.domain.entity;

import javax.persistence.*;
import java.math.BigDecimal;
import java.util.Date;

@Entity
@Table(name = "dc_long_terms_storage_fee", schema = "bailun_datacenter")
public class DcLongTermsStorageFee {
    private Integer id;
    private Date snapshotDate;
    private String sku;
    private String fnsku;
    private String asin;
    private String productName;
    private String productCondition;
    private BigDecimal perUnitVolume;
    private String currency;
    @Column(name = "quantity_gt12month")
    private BigDecimal quantityGt12Month;
    @Column(name = "storage_fee_gt12month")
    private BigDecimal storageFeeGt12Month;
    @Column(name = "quantity_gt6month")
    private BigDecimal quantityGt6Month;
    @Column(name = "storage_fee_gt6month")
    private BigDecimal storageFeeGt6Month;
    private String volumeUnit;
    private String country;
    private String smallAndLight;
    private String platform;
    private String sellerId;
    private String bailunAccount;
    private Date gmtCreate;
    private Date gmtModified;

    @Id
    @Column(name = "id", nullable = false)
    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @Basic
    @Column(name = "snapshot_date", nullable = true)
    public Date getSnapshotDate() {
        return snapshotDate;
    }

    public void setSnapshotDate(Date snapshotDate) {
        this.snapshotDate = snapshotDate;
    }

    @Basic
    @Column(name = "sku", nullable = false, length = 100)
    public String getSku() {
        return sku;
    }

    public void setSku(String sku) {
        this.sku = sku;
    }

    @Basic
    @Column(name = "fnsku", nullable = false, length = 100)
    public String getFnsku() {
        return fnsku;
    }

    public void setFnsku(String fnsku) {
        this.fnsku = fnsku;
    }

    @Basic
    @Column(name = "asin", nullable = false, length = 100)
    public String getAsin() {
        return asin;
    }

    public void setAsin(String asin) {
        this.asin = asin;
    }

    @Basic
    @Column(name = "product_name", nullable = false, length = 500)
    public String getProductName() {
        return productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    @Basic
    @Column(name = "product_condition", nullable = false, length = 30)
    public String getProductCondition() {
        return productCondition;
    }

    public void setProductCondition(String productCondition) {
        this.productCondition = productCondition;
    }

    @Basic
    @Column(name = "per_unit_volume", nullable = false, precision = 4)
    public BigDecimal getPerUnitVolume() {
        return perUnitVolume;
    }

    public void setPerUnitVolume(BigDecimal perUnitVolume) {
        this.perUnitVolume = perUnitVolume;
    }

    @Basic
    @Column(name = "currency", nullable = false, length = 10)
    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Basic
    @Column(name = "quantity_gt12month", nullable = false, precision = 3)
    public BigDecimal getQuantityGt12Month() {
        return quantityGt12Month;
    }

    public void setQuantityGt12Month(BigDecimal quantityGt12Month) {
        this.quantityGt12Month = quantityGt12Month;
    }

    @Basic
    @Column(name = "storage_fee_gt12month", nullable = false, precision = 3)
    public BigDecimal getStorageFeeGt12Month() {
        return storageFeeGt12Month;
    }

    public void setStorageFeeGt12Month(BigDecimal storageFeeGt12Month) {
        this.storageFeeGt12Month = storageFeeGt12Month;
    }

    @Basic
    @Column(name = "quantity_gt6month", nullable = false, precision = 3)
    public BigDecimal getQuantityGt6Month() {
        return quantityGt6Month;
    }

    public void setQuantityGt6Month(BigDecimal quantityGt6Month) {
        this.quantityGt6Month = quantityGt6Month;
    }

    @Basic
    @Column(name = "storage_fee_gt6month", nullable = false, precision = 3)
    public BigDecimal getStorageFeeGt6Month() {
        return storageFeeGt6Month;
    }

    public void setStorageFeeGt6Month(BigDecimal storageFeeGt6Month) {
        this.storageFeeGt6Month = storageFeeGt6Month;
    }

    @Basic
    @Column(name = "volume_unit", nullable = false, length = 10)
    public String getVolumeUnit() {
        return volumeUnit;
    }

    public void setVolumeUnit(String volumeUnit) {
        this.volumeUnit = volumeUnit;
    }

    @Basic
    @Column(name = "country", nullable = false, length = 30)
    public String getCountry() {
        return country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    @Basic
    @Column(name = "small_and_light", nullable = false, length = 10)
    public String getSmallAndLight() {
        return smallAndLight;
    }

    public void setSmallAndLight(String smallAndLight) {
        this.smallAndLight = smallAndLight;
    }

    @Basic
    @Column(name = "platform", nullable = false, length = 20)
    public String getPlatform() {
        return platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    @Basic
    @Column(name = "seller_id", nullable = false, length = 100)
    public String getSellerId() {
        return sellerId;
    }

    public void setSellerId(String sellerId) {
        this.sellerId = sellerId;
    }

    @Basic
    @Column(name = "bailun_account", nullable = false, length = 100)
    public String getBailunAccount() {
        return bailunAccount;
    }

    public void setBailunAccount(String bailunAccount) {
        this.bailunAccount = bailunAccount;
    }

    @Basic
    @Column(name = "gmt_create", nullable = false)
    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    @Basic
    @Column(name = "gmt_modified", nullable = false)
    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        DcLongTermsStorageFee that = (DcLongTermsStorageFee) o;

        if (id != that.id) return false;
        if (snapshotDate != null ? !snapshotDate.equals(that.snapshotDate) : that.snapshotDate != null) return false;
        if (sku != null ? !sku.equals(that.sku) : that.sku != null) return false;
        if (fnsku != null ? !fnsku.equals(that.fnsku) : that.fnsku != null) return false;
        if (asin != null ? !asin.equals(that.asin) : that.asin != null) return false;
        if (productName != null ? !productName.equals(that.productName) : that.productName != null) return false;
        if (productCondition != null ? !productCondition.equals(that.productCondition) : that.productCondition != null)
            return false;
        if (perUnitVolume != null ? !perUnitVolume.equals(that.perUnitVolume) : that.perUnitVolume != null)
            return false;
        if (currency != null ? !currency.equals(that.currency) : that.currency != null) return false;
        if (quantityGt12Month != null ? !quantityGt12Month.equals(that.quantityGt12Month) : that.quantityGt12Month != null)
            return false;
        if (storageFeeGt12Month != null ? !storageFeeGt12Month.equals(that.storageFeeGt12Month) : that.storageFeeGt12Month != null)
            return false;
        if (quantityGt6Month != null ? !quantityGt6Month.equals(that.quantityGt6Month) : that.quantityGt6Month != null)
            return false;
        if (storageFeeGt6Month != null ? !storageFeeGt6Month.equals(that.storageFeeGt6Month) : that.storageFeeGt6Month != null)
            return false;
        if (volumeUnit != null ? !volumeUnit.equals(that.volumeUnit) : that.volumeUnit != null) return false;
        if (country != null ? !country.equals(that.country) : that.country != null) return false;
        if (smallAndLight != null ? !smallAndLight.equals(that.smallAndLight) : that.smallAndLight != null)
            return false;
        if (platform != null ? !platform.equals(that.platform) : that.platform != null) return false;
        if (sellerId != null ? !sellerId.equals(that.sellerId) : that.sellerId != null) return false;
        if (bailunAccount != null ? !bailunAccount.equals(that.bailunAccount) : that.bailunAccount != null)
            return false;
        if (gmtCreate != null ? !gmtCreate.equals(that.gmtCreate) : that.gmtCreate != null) return false;
        if (gmtModified != null ? !gmtModified.equals(that.gmtModified) : that.gmtModified != null) return false;

        return true;
    }

    @Override
    public int hashCode() {
        int result = id;
        result = 31 * result + (snapshotDate != null ? snapshotDate.hashCode() : 0);
        result = 31 * result + (sku != null ? sku.hashCode() : 0);
        result = 31 * result + (fnsku != null ? fnsku.hashCode() : 0);
        result = 31 * result + (asin != null ? asin.hashCode() : 0);
        result = 31 * result + (productName != null ? productName.hashCode() : 0);
        result = 31 * result + (productCondition != null ? productCondition.hashCode() : 0);
        result = 31 * result + (perUnitVolume != null ? perUnitVolume.hashCode() : 0);
        result = 31 * result + (currency != null ? currency.hashCode() : 0);
        result = 31 * result + (quantityGt12Month != null ? quantityGt12Month.hashCode() : 0);
        result = 31 * result + (storageFeeGt12Month != null ? storageFeeGt12Month.hashCode() : 0);
        result = 31 * result + (quantityGt6Month != null ? quantityGt6Month.hashCode() : 0);
        result = 31 * result + (storageFeeGt6Month != null ? storageFeeGt6Month.hashCode() : 0);
        result = 31 * result + (volumeUnit != null ? volumeUnit.hashCode() : 0);
        result = 31 * result + (country != null ? country.hashCode() : 0);
        result = 31 * result + (smallAndLight != null ? smallAndLight.hashCode() : 0);
        result = 31 * result + (platform != null ? platform.hashCode() : 0);
        result = 31 * result + (sellerId != null ? sellerId.hashCode() : 0);
        result = 31 * result + (bailunAccount != null ? bailunAccount.hashCode() : 0);
        result = 31 * result + (gmtCreate != null ? gmtCreate.hashCode() : 0);
        result = 31 * result + (gmtModified != null ? gmtModified.hashCode() : 0);
        return result;
    }
}
