package com.bailuntec.job;

import com.bailuntec.domain.dto.TransferTransitQuantity;
import com.bailuntec.mapper.DcMidTransitMapper;
import com.bailuntec.utils.SessionUtil;
import com.dangdang.ddframe.job.api.ShardingContext;
import com.dangdang.ddframe.job.api.simple.SimpleJob;
import lombok.extern.slf4j.Slf4j;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.TransactionIsolationLevel;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

@Slf4j
public class CalculateTransferTransit implements SimpleJob {

    @Override
    public void execute(ShardingContext shardingContext) {
        SqlSession sqlSession = SessionUtil.getFactory().openSession(TransactionIsolationLevel.READ_UNCOMMITTED);
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime localDateTime = LocalDateTime.now();
        try {
            DcMidTransitMapper mapper = sqlSession.getMapper(DcMidTransitMapper.class);
            List<TransferTransitQuantity> transferTransitQuantityList = mapper.selectQuantityTransferTransit();
            if(transferTransitQuantityList != null) {
                mapper.calculateTransferTransit(transferTransitQuantityList, localDateTime);
            }
            sqlSession.commit();
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("计算调拨在途数失败",e);
        } finally {
            if (sqlSession != null) {
                sqlSession.close();
            }
        }
        SqlSession sqlSessionUpdate = SessionUtil.getFactory().openSession(TransactionIsolationLevel.READ_UNCOMMITTED);
        try {
            DcMidTransitMapper mapper = sqlSessionUpdate.getMapper(DcMidTransitMapper.class);
         //   LocalDateTime localDateTime = mapper.selectMaxTransferModified();
            mapper.updateOldTransferToZero(df.format(localDateTime));
            sqlSessionUpdate.commit();
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("更新调拨在途数失败",e);
        } finally {
            if (sqlSessionUpdate != null) {
                sqlSessionUpdate.close();
            }
        }
    }
}
