package com.bailuntec.balancesheet.util;

import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

import javax.net.ssl.SSLContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;

/**
 * 网络请求工具类
 */
public class HttpUtil {
    public static RestTemplate restTemplate = new RestTemplate();
    /**
     * 设置跨域请求头
     * @param response
     * @param request
     */
    public static void setCors(HttpServletResponse response, HttpServletRequest request) {
        String origin = request.getHeader("Origin");
        response.setHeader("Access-Control-Allow-Origin", origin);
        response.setHeader("Access-Control-Allow-Methods", "POST, GET, PUT, DELETE");
        response.setHeader("Access-Control-Allow-Credentials", "true");
    }

    /**
     * 发起http get请求
     * @param url
     * @return
     * @throws Exception
     */
    public static String httpGet(String url) throws Exception{
        return restTemplate.getForObject(url, String.class);
    }

    /**
     * 发起http post请求
     * @param url
     * @param paramsJson
     * @return
     * @throws Exception
     */
    public static String httpPost(String url, String paramsJson) throws Exception{
        HttpHeaders headers = new HttpHeaders();
        MediaType type = MediaType.parseMediaType("application/json; charset=UTF-8");
        headers.setContentType(type);
        HttpEntity<String> requestEntity = new HttpEntity<>(paramsJson, headers);
        return restTemplate.postForObject(url, requestEntity, String.class);
    }

    /**
     * 获取https请求的RestTemplete
     * @return
     * @throws KeyStoreException
     * @throws NoSuchAlgorithmException
     * @throws KeyManagementException
     */
    public static RestTemplate getHttpsRestTemplate() throws KeyStoreException, NoSuchAlgorithmException, KeyManagementException {
        TrustStrategy acceptingTrustStrategy = (X509Certificate[] chain, String authType) -> true;
        SSLContext sslContext = org.apache.http.ssl.SSLContexts.custom().loadTrustMaterial(null, acceptingTrustStrategy).build();
        SSLConnectionSocketFactory csf = new SSLConnectionSocketFactory(sslContext);
        CloseableHttpClient httpClient = HttpClients.custom().setSSLSocketFactory(csf).build();
        HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory();
        requestFactory.setHttpClient(httpClient);
        return new RestTemplate(requestFactory);
    }

    /**
     * 发送https get请求
     * @param url
     * @return
     * @throws Exception
     */
    public static String httpsGet(String url) throws Exception{
        RestTemplate restTemplate = getHttpsRestTemplate();
        return restTemplate.getForObject(url, String.class);
    }

}