package com.bailuntec.balancesheet.mapper;

import com.bailuntec.balancesheet.dto.ExchangeRateDTO;
import com.bailuntec.balancesheet.entity.DcExchangeRate;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.springframework.stereotype.Repository;

import javax.validation.constraints.Digits;
import java.util.Date;
import java.util.List;

@Repository
public interface DcExchangeRateMapper {
    @Insert("<script>" +
            "insert ignore into dc_exchange_rate(init_curreny,final_curreny,exchange_rate,record_time) values" +
            "<foreach collection='list' item='item' index='index' separator=','>" +
            "(#{item.fromCur},#{item.toCur},#{item.rate},#{date})" +
            " </foreach>" +
            "</script>")
    void insertToCnyExchangeRates(@Param("list") List<ExchangeRateDTO> exchangeRateDTOList, @Param("date") Date date);

    @Select("select count(1) from dc_exchange_rate where final_curreny = 'CNY' and record_time = #{lastDay}")
    Long countLastDayExchageRate(@Param("lastDay") Date lastDay);
}
