package com.bailuntec.domain.pojo.costfirstfinish;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@Data
public class CostFirstFinishData {

    @JSONField(name = "channelOrderNo")
    private String channelOrderId;

    @JSONField(name = "orderCode")
    private String transferOrderId;

    @JSONField(name = "id")
    private Integer channelId;

    @JSONField(name = "boxCode")
    private String boxId;

    @JSONField(name = "wareCode")
    private String warehouseCode;

    private List<CostFirstFinishSku> skus;

    //燃油附加费
    @JSONField(name = "fuelFee")
    private BigDecimal costFuel;

    //原始重量邮费
    @JSONField(name = "weightFee")
    private BigDecimal costWeight;

    //清关费
    @JSONField(name = "customsClearanceFee")
    private BigDecimal costCustomsClearance;

    //关税预付
    @JSONField(name = "dutyFee")
    private BigDecimal costDuty;

    //报关费
    @JSONField(name = "clearanceGoodsFee")
    private BigDecimal costGoodsClearance;

    //总费用
    @JSONField(name = "moneyRMB")
    private BigDecimal costFirst;

    @JSONField(name = "operationTime")
    private LocalDateTime operationTime;

    @JSONField(name = "stateId")
    private Integer stateId;

    @JSONField(name = "stateName")
    private String stateName;
}
