package com.bailuntec.job;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.bailuntec.domain.entity.DcBaseCompanyInfo;
import com.bailuntec.domain.entity.JobPointLog;
import com.bailuntec.domain.example.DcBaseCompanyInfoExample;
import com.bailuntec.domain.pojo.CompanyInfo;
import com.bailuntec.domain.pojo.Result;
import com.bailuntec.mapper.DcBaseCompanyInfoMapper;
import com.bailuntec.support.PointJob;
import com.bailuntec.utils.OkHttpUtil;
import com.bailuntec.utils.PropertiesUtil;
import com.bailuntec.utils.SessionUtil;
import com.dangdang.ddframe.job.api.ShardingContext;
import lombok.extern.slf4j.Slf4j;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.StringUtils;

import java.io.IOException;
import java.time.LocalDateTime;
import java.util.List;

@Slf4j
public class CompanyInfoSyncJob extends PointJob {
    private PropertiesUtil propertiesUtil = PropertiesUtil.getInstance("const");
    private OkHttpClient client = OkHttpUtil.getInstance();

    @Override
    public void executeJob(ShardingContext shardingContext, JobPointLog jobPointLog) {
            Request request = new Request.Builder()
                    .url(propertiesUtil.getPropertyAsString("COMPANY_INFO_URL"))
                    .get()
                    .addHeader("Content-Type", "application/json")
                    .build();
            Response response = null;
            String resultStr = null;
            try {
                response = client.newCall(request).execute();
                resultStr = response.body().string();
            } catch (IOException e) {
                throw new RuntimeException("调用公司信息接口失败", e);
            } finally {
                if (response != null) {
                    response.close();
                }
            }
            if (StringUtils.isNotBlank(resultStr)) {
                Result<CompanyInfo> companyInfoResult = JSONObject.parseObject(resultStr, new TypeReference<Result<CompanyInfo>>(){});
                if (companyInfoResult.getStatusCode()!= null && companyInfoResult.getStatusCode().equals(200)) {
                    List<CompanyInfo> result = companyInfoResult.getResult();
                    if (result != null && result.size() > 0) {
                        DcBaseCompanyInfoMapper mapper = SessionUtil.getSession().getMapper(DcBaseCompanyInfoMapper.class);
                        DcBaseCompanyInfo dcBaseCompanyInfo = new DcBaseCompanyInfo();
                        try {
                            for (CompanyInfo companyInfo : result) {
                                BeanUtils.copyProperties(dcBaseCompanyInfo, companyInfo);
                                dcBaseCompanyInfo.setGmtModified(LocalDateTime.now());
                                int i = mapper.updateByExampleSelective(dcBaseCompanyInfo, DcBaseCompanyInfoExample.newAndCreateCriteria().andCompanyIdEqualTo(dcBaseCompanyInfo.getCompanyId()).example());
                                if (i == 0) {
                                    mapper.insertSelective(dcBaseCompanyInfo);
                                }
                            }
                        } catch (Exception e) {
                           throw new RuntimeException("Mybatis操作DB失败",e);
                        } finally {
                            SessionUtil.closeSession();
                        }
                    }
                } else {
                    throw new RuntimeException("调用公司信息接口返回错误");
                }
            } else {
                throw new RuntimeException("调用公司信息接口返回null");
            }
    }

}
