package com.bailuntec.job;

import com.alibaba.fastjson.JSON;
import com.bailuntec.domain.LogisticsInfo;
import com.bailuntec.domain.constant.CommonConstant;
import com.bailuntec.domain.entity.DcBaseFinanceLogistics;
import com.bailuntec.domain.entity.JobPointLog;
import com.bailuntec.mapper.DcBaseFinanceLogisticsMapper;
import com.bailuntec.support.PointJob;
import com.bailuntec.utils.OkHttpUtil;
import com.bailuntec.utils.PropertiesUtil;
import com.bailuntec.utils.SessionUtil;
import com.dangdang.ddframe.job.api.ShardingContext;
import lombok.extern.slf4j.Slf4j;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;

import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.List;

@Slf4j
public class LogisticsJob extends PointJob {

    private OkHttpClient okHttpClient = OkHttpUtil.getInstance();
    private PropertiesUtil propertiesUtil = PropertiesUtil.getInstance("const");

    @Override
    public void executeJob(ShardingContext shardingContext, JobPointLog jobPointLog) {
        LinkedHashMap<String, String> map = new LinkedHashMap<>(4);
        map.put("startDate", DateTimeFormatter.ofPattern(CommonConstant.DATE_FORMAT).format(jobPointLog.getStartTime().minusHours(3l)));
        map.put("endDate", DateTimeFormatter.ofPattern(CommonConstant.DATE_FORMAT).format(jobPointLog.getEndTime()));
            Response response = null;
            String palResultStr = null;
            try {
                Request request = new Request.Builder()
                        .get()
                        .url(OkHttpUtil.attachHttpGetParams(propertiesUtil.getPropertyAsString("LOGISTICS_URL"), map))
                        .addHeader("Content-Type", "application/json")
                        .build();
                response = okHttpClient.newCall(request).execute();
                palResultStr = response.body().string();
            } catch (IOException e) {
                throw new RuntimeException(map + "请求物流接口同步百伦接口失败" + response, e);
            } finally {
                if (response != null) {
                    response.close();
                }
            }
            if (StringUtils.isNoneBlank(palResultStr)) {
                LogisticsInfo logisticsInfo = JSON.parseObject(palResultStr, LogisticsInfo.class);
                if (logisticsInfo != null && logisticsInfo.isSuccess() && logisticsInfo.getData().size() > 0) {
                    List<DcBaseFinanceLogistics> logisticsList = logisticsInfo.getData();
                    for(DcBaseFinanceLogistics dcBaseFinanceLogistics : logisticsList) {
                        try {
                            DcBaseFinanceLogisticsMapper dcBaseFinanceLogisticsMapper = SessionUtil.getSession().getMapper(DcBaseFinanceLogisticsMapper.class);
                            dcBaseFinanceLogisticsMapper.upsertSelective(dcBaseFinanceLogistics);
                        } catch (Exception e) {
                            throw new RuntimeException("MyBatis 操作失败!");
                        }finally {
                            SessionUtil.closeSession();
                        }
                    }
                } else {
                    log.warn("请求结果：" + palResultStr + "请求参数：" + map.toString());
                }
            } else {
                throw new RuntimeException("调用物流接口同步百伦流水失败, 响应为null, 请求参数" + map.toString());
            }
        jobPointLog.setStartTime(jobPointLog.getEndTime());
        jobPointLog.setEndTime(jobPointLog.getEndTime().plusDays(jobPointLog.getIntervalTime()).isAfter(LocalDateTime.now()) ? LocalDateTime.now() : jobPointLog.getEndTime().plusDays(jobPointLog.getIntervalTime()));

    }
}
