import com.bailuntec.domain.entity.JobAccountLog;
import com.bailuntec.domain.entity.JobAmazonAdLog;
import com.bailuntec.domain.example.JobAmazonAdLogExample;
import com.bailuntec.mapper.JobAmazonAdLogMapper;
import com.bailuntec.utils.SessionUtil;
import lombok.extern.slf4j.Slf4j;
import org.junit.jupiter.api.Test;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.LocalDateTime;
import java.util.List;

@Slf4j
public class AmazonAdProductTest {

    @Test
    public void test() throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException, InstantiationException {
        Class clazz = Class.forName("com.bailuntec.job.AmazonAdGenerateReportIdJob");
        Method generateReportId = clazz.getDeclaredMethod("generateReportId", JobAccountLog.class);
        generateReportId.setAccessible(true);
        JobAccountLog jobAccountLog = new JobAccountLog();
        jobAccountLog.setStartTime(LocalDateTime.of(2019, 5, 31, 0, 0));
        jobAccountLog.setEndTime(LocalDateTime.of(2019, 6, 1, 0, 0));
        jobAccountLog.setCompanyId(1);
        jobAccountLog.setAccountId(572);
        jobAccountLog.setIntervalTime(1);
        jobAccountLog.setJobName("base-amazon-ad-product-generate");
        generateReportId.invoke(clazz.newInstance(), jobAccountLog);
    }

    @Test
    public void test2() throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException, InstantiationException {
        Class clazz = Class.forName("com.bailuntec.job.AmazonAdDownloadReportJob");
        Method generateReportId = clazz.getDeclaredMethod("downloadReport", JobAmazonAdLog.class);
        int pageSize = 10;
        generateReportId.setAccessible(true);
        try {
            JobAmazonAdLogMapper mapper = SessionUtil.getSession().getMapper(JobAmazonAdLogMapper.class);
            List<JobAmazonAdLog> jobAmazonAdLogList = mapper.selectByExample(JobAmazonAdLogExample.newAndCreateCriteria().andStatusEqualTo(false).andBjModifiedLessThan(LocalDateTime.now().minusMinutes(15)).example().orderBy("id").limit(0 * pageSize, pageSize));
            if (jobAmazonAdLogList != null && !jobAmazonAdLogList.isEmpty()) {
                for (JobAmazonAdLog jobAmazonAdLog : jobAmazonAdLogList) {
                    generateReportId.invoke(clazz.newInstance(), jobAmazonAdLog);
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            SessionUtil.closeSession();
        }
    }

    @Test
    public void test3() throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException, InstantiationException {
        Class clazz = Class.forName("com.bailuntec.job.AmazonAdDownloadReportJob");
        Method generateReportId = clazz.getDeclaredMethod("downloadReport", JobAmazonAdLog.class);
        int pageSize = 1;
        generateReportId.setAccessible(true);
        try {
            JobAmazonAdLogMapper mapper = SessionUtil.getSession().getMapper(JobAmazonAdLogMapper.class);
            List<JobAmazonAdLog> jobAmazonAdLogList = mapper.selectByExample(JobAmazonAdLogExample.newAndCreateCriteria().andStatusEqualTo(false).andIdEqualTo(1969).andBjModifiedLessThan(LocalDateTime.now().minusMinutes(15)).example().orderBy("id").limit(0 * pageSize, pageSize));
            if (jobAmazonAdLogList != null && !jobAmazonAdLogList.isEmpty()) {
                for (JobAmazonAdLog jobAmazonAdLog : jobAmazonAdLogList) {
                    generateReportId.invoke(clazz.newInstance(), jobAmazonAdLog);
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            SessionUtil.closeSession();
        }
    }

}
