package com.bailuntec.job;

import com.bailuntec.domain.entity.*;
import com.bailuntec.domain.example.*;
import com.bailuntec.mapper.*;
import com.bailuntec.support.PointJob;
import com.bailuntec.utils.SessionUtil;
import com.dangdang.ddframe.job.api.ShardingContext;
import lombok.extern.slf4j.Slf4j;
import java.time.LocalDateTime;
import java.util.List;

@Slf4j
public class SyncWarehouseStockJob extends PointJob {

    @Override
    public void executeJob(ShardingContext shardingContext, JobPointLog jobPointLog) {
        syncPurchaseInbound(shardingContext, jobPointLog);
        syncTransferComplete(shardingContext, jobPointLog);
        syncOrderPick(shardingContext, jobPointLog);
        jobPointLog.setStartTime(jobPointLog.getEndTime());
        jobPointLog.setEndTime(jobPointLog.getStartTime().plusDays(jobPointLog.getIntervalTime().longValue()).isAfter(LocalDateTime.now()) ? LocalDateTime.now() : jobPointLog.getStartTime().plusDays(jobPointLog.getIntervalTime().longValue()));
    }



    public void syncPurchaseInbound(ShardingContext shardingContext, JobPointLog jobPointLog) {
        jobPointLog.setPageIndex(jobPointLog.getPageIndex() != 1 ? 1 : jobPointLog.getPageIndex());
        Integer pickSize = 0;
        try {
            // 查询采购入库数量
            DcBaseStockRecordMapper dcBaseStockRecordMapper = SessionUtil.getSession().getMapper(DcBaseStockRecordMapper.class);
            pickSize = dcBaseStockRecordMapper.selectPurchaseInboundCount(jobPointLog);
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("MYbatis操作DB失败", e);
        } finally {
            SessionUtil.closeSession();
        }

        Integer pageSize = pickSize % jobPointLog.getPageSize() == 0 ? pickSize/jobPointLog.getPageSize() : pickSize/jobPointLog.getPageSize() + 1;

        do{
            DcBaseStockRecordMapper dcBaseStockRecordMapper = SessionUtil.getSession().getMapper(DcBaseStockRecordMapper.class);
            List<DcBasePurchaseInbound> dcBasePurchaseInboundList = dcBaseStockRecordMapper.selectPurchaseInboundByLimit(jobPointLog.getStartTime(), jobPointLog.getEndTime(), (jobPointLog.getPageIndex() - 1) * jobPointLog.getPageSize(), jobPointLog.getPageSize());
            for(DcBasePurchaseInbound dcBasePurchaseInbound : dcBasePurchaseInboundList) {
                try {
                    DcBaseStockRecord dcBaseStockRecord = new DcBaseStockRecord();
                    dcBaseStockRecord.setStockTime(dcBasePurchaseInbound.getUpdateTime());
                    dcBaseStockRecord.setBailunSku(dcBasePurchaseInbound.getBailunSku());
                    dcBaseStockRecord.setWarehouseCode(dcBasePurchaseInbound.getWarehouseCode());
                    dcBaseStockRecord.setQuantityStock(dcBasePurchaseInbound.getCount());
                    dcBaseStockRecord.setHasTransfer(0);
                    DcBaseStockRecordMapper mapper = SessionUtil.getSession().getMapper(DcBaseStockRecordMapper.class);
                    int i = mapper.updateByExampleSelective(dcBaseStockRecord, DcBaseStockRecordExample.newAndCreateCriteria()
                            .andBailunSkuEqualTo(dcBaseStockRecord.getBailunSku())
                            .andWarehouseCodeEqualTo(dcBaseStockRecord.getWarehouseCode())
                            .andStockTimeEqualTo(dcBaseStockRecord.getStockTime())
                            .andHasTransferEqualTo(dcBaseStockRecord.getHasTransfer())
                            .example());
                    if (i == 0) {
                        mapper.insertSelective(dcBaseStockRecord);
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                    throw new RuntimeException("MYbatis操作DB失败", e);
                } finally {
                    SessionUtil.closeSession();
                }
            }
            jobPointLog.setPageIndex(jobPointLog.getPageIndex() + 1);
        }while (jobPointLog.getPageIndex() <= pageSize);
    }

    public void syncTransferComplete(ShardingContext shardingContext, JobPointLog jobPointLog) {
        jobPointLog.setPageIndex(jobPointLog.getPageIndex() !=1 ? 1 : jobPointLog.getPageIndex());
        Integer pickPage = 0;
        try{
            DcBaseStockRecordMapper dcBaseStockRecordMapper = SessionUtil.getSession().getMapper(DcBaseStockRecordMapper.class);
            pickPage = dcBaseStockRecordMapper.selectTransferCount(jobPointLog);
        }catch(Exception e) {
            e.printStackTrace();
            throw new RuntimeException("MYbatis操作失败", e);
        }finally {
            SessionUtil.closeSession();
        }
        Integer pageSize = pickPage % jobPointLog.getPageSize() == 0 ? pickPage/jobPointLog.getPageSize() : pickPage/jobPointLog.getPageSize() + 1;
        do{
            DcBaseStockRecordMapper dcBaseStockRecordMapper = SessionUtil.getSession().getMapper(DcBaseStockRecordMapper.class);
            List<DcBaseTransferComplete> dcBaseTransferCompleteList = dcBaseStockRecordMapper.selectTransferCompleteByLimit(jobPointLog.getStartTime(), jobPointLog.getEndTime(), (jobPointLog.getPageIndex() - 1) * jobPointLog.getPageSize(), jobPointLog.getPageSize());
                for(DcBaseTransferComplete dcBaseTransferComplete : dcBaseTransferCompleteList) {
                try {
                    DcBaseStockRecord dcBaseStockRecord = new DcBaseStockRecord();
                    dcBaseStockRecord.setStockTime(dcBaseTransferComplete.getCreateTime());
                    dcBaseStockRecord.setBailunSku(dcBaseTransferComplete.getBailunSku());
                    dcBaseStockRecord.setWarehouseCode(dcBaseTransferComplete.getWarehouseCode());
                    dcBaseStockRecord.setQuantityStock(dcBaseTransferComplete.getCount());
                    dcBaseStockRecord.setHasTransfer(1);
                    DcBaseStockRecordMapper mapper = SessionUtil.getSession().getMapper(DcBaseStockRecordMapper.class);
                    int i = mapper.updateByExampleSelective(dcBaseStockRecord, DcBaseStockRecordExample.newAndCreateCriteria()
                            .andBailunSkuEqualTo(dcBaseStockRecord.getBailunSku())
                            .andWarehouseCodeEqualTo(dcBaseStockRecord.getWarehouseCode())
                            .andStockTimeEqualTo(dcBaseStockRecord.getStockTime())
                            .andHasTransferEqualTo(dcBaseStockRecord.getHasTransfer())
                            .example());
                    if (i == 0) {
                        mapper.insertSelective(dcBaseStockRecord);
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                    throw new RuntimeException("MYbatis操作DB失败", e);
                } finally {
                    SessionUtil.closeSession();
                }


                try{
                    DcBaseStockOut dcBaseStockOut = new DcBaseStockOut();
                    if(dcBaseTransferComplete.getSourceWarehouseCode() != null) {
                        dcBaseStockOut.setWarehouseCode(dcBaseTransferComplete.getSourceWarehouseCode());
                        dcBaseStockOut.setStockTime(dcBaseTransferComplete.getCreateTime());
                        dcBaseStockOut.setBailunSku(dcBaseTransferComplete.getBailunSku());
                        dcBaseStockOut.setQuantityStock(dcBaseTransferComplete.getCount());
                        dcBaseStockOut.setHasTransfer(1);
                        try {
                            DcBaseStockOutMapper mapper = SessionUtil.getSession().getMapper(DcBaseStockOutMapper.class);
                            int i = mapper.updateByExampleSelective(dcBaseStockOut, DcBaseStockOutExample.newAndCreateCriteria()
                                    .andBailunSkuEqualTo(dcBaseStockOut.getBailunSku())
                                    .andWarehouseCodeEqualTo(dcBaseStockOut.getWarehouseCode())
                                    .andStockTimeEqualTo(dcBaseStockOut.getStockTime())
                                    .andHasTransferEqualTo(dcBaseStockOut.getHasTransfer())
                                    .example());
                            if (i == 0) {
                                mapper.insertSelective(dcBaseStockOut);
                            }
                        } catch (Exception e) {
                            e.printStackTrace();
                            throw new RuntimeException("MYbatis操作DB失败", e);
                        } finally {
                            SessionUtil.closeSession();
                        }
                    }
                }catch (Exception e) {
                    e.printStackTrace();
                    throw new RuntimeException("MYbatis操作DB失败", e);
                }finally {
                    SessionUtil.closeSession();
                }
            }
            jobPointLog.setPageIndex(jobPointLog.getPageIndex() + 1);
        }while(jobPointLog.getPageIndex() <= pageSize);
    }

    public void syncOrderPick(ShardingContext shardingContext, JobPointLog jobPointLog) {
        jobPointLog.setPageIndex(jobPointLog.getPageIndex() == 0 ? 1 : jobPointLog.getPageIndex());
        Integer pickSize = 0;
        try {
            DcBaseStockRecordMapper dcBaseStockRecordMapper = SessionUtil.getSession().getMapper(DcBaseStockRecordMapper.class);
            pickSize = dcBaseStockRecordMapper.selectOrderPickCount(jobPointLog);
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("MYbatis操作DB失败", e);
        } finally {
            SessionUtil.closeSession();
        }
        Integer pageSize = pickSize % jobPointLog.getPageSize() == 0 ? pickSize/jobPointLog.getPageSize() : pickSize/jobPointLog.getPageSize() + 1;
        do{
            DcBaseStockRecordMapper dcBaseStockRecordMapper1 = SessionUtil.getSession().getMapper(DcBaseStockRecordMapper.class);
            List<DcBaseOmsPick> dcBaseOmsPickList = dcBaseStockRecordMapper1.selectOrderPickByLimit(jobPointLog.getStartTime(), jobPointLog.getEndTime(), (jobPointLog.getPageIndex() - 1) * jobPointLog.getPageSize(), jobPointLog.getPageSize());
            for(DcBaseOmsPick dcBaseOmsPick : dcBaseOmsPickList) {
                DcBaseStockOut dcBaseStockOut = new DcBaseStockOut();
                dcBaseStockOut.setWarehouseCode(dcBaseOmsPick.getWarehouseCode());
                dcBaseStockOut.setWarehouseName(dcBaseOmsPick.getWarehouseName());
                dcBaseStockOut.setStockTime(dcBaseOmsPick.getShippingTime());
                dcBaseStockOut.setBailunSku(dcBaseOmsPick.getBailunSku());
                dcBaseStockOut.setQuantityStock(dcBaseOmsPick.getQuantityShipped());
                dcBaseStockOut.setHasTransfer(0);
                try {
                    DcBaseStockOutMapper mapper = SessionUtil.getSession().getMapper(DcBaseStockOutMapper.class);
                    int i = mapper.updateByExampleSelective(dcBaseStockOut, DcBaseStockOutExample.newAndCreateCriteria()
                            .andBailunSkuEqualTo(dcBaseStockOut.getBailunSku())
                            .andWarehouseCodeEqualTo(dcBaseStockOut.getWarehouseCode())
                            .andStockTimeEqualTo(dcBaseStockOut.getStockTime())
                            .andHasTransferEqualTo(dcBaseStockOut.getHasTransfer())
                            .example());
                    if (i == 0) {
                        mapper.insertSelective(dcBaseStockOut);
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                    throw new RuntimeException("MYbatis操作DB失败", e);
                } finally {
                    SessionUtil.closeSession();
                }
            }
            jobPointLog.setPageIndex(jobPointLog.getPageIndex() + 1);
        }while(jobPointLog.getPageIndex() <= pageSize);

    }
}
