package com.bailuntec.balancesheet.dto;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

@Data
public class SupplierTransactionDTO {
    @JSONField(name = "PayCompanyId")
    private Integer payCompanyValue;
    @JSONField(name = "PayCompanyName")
    private String payCompanyName;
    @JSONField(name = "SupplierId")
    private Integer supplierId;
    @JSONField(name = "SupplierName")
    private String supplierName;
    @JSONField(name = "ParentSupplierId")
    private Integer parentSupplierId;
    @JSONField(name = "ParentSupplierName")
    private String parentSupplierName;
    @JSONField(name = "PutinAmount")
    private BigDecimal puttingAmount;
    @JSONField(name = "ExpressAmount")
    private BigDecimal expressAmount;
    @JSONField(name = "PayAmount")
    private BigDecimal payAmount;
    @JSONField(name = "ReturnAmount")
    private BigDecimal returnAmount;
    @JSONField(name = "ReturnExpress")
    private BigDecimal returnExpress;
    @JSONField(name = "ReceviceAmount")
    private BigDecimal receiveAmount;
    @JSONField(name = "AdjustAmount")
    private BigDecimal adjustAmount;
    @JSONField(name = "StartAmount")
    private BigDecimal startAmount;
    @JSONField(name = "EndAmount")
    private BigDecimal endAmount;
    @JSONField(name = "Day", format = "yyyy/MM/dd HH:mm:ss")
    private Date day;
    @JSONField(name = "Types")
    private Integer types;
    @JSONField(name = "IsFinish")
    private Integer isFinish;
    @JSONField(name = "DelayNoPayAmount")
    private BigDecimal delayNoPayAmount;
}
