package com.bailuntec.support;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import org.apache.ibatis.datasource.DataSourceFactory;

import javax.sql.DataSource;
import java.util.Properties;

public class DruidDataSourceFactory implements DataSourceFactory {
    private Properties props;

    @Override
    public void setProperties(Properties props) {
        this.props = props;
    }

    @Override
    public DataSource getDataSource() {
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setDriverClassName(this.props.getProperty("driver"));
        hikariConfig.setJdbcUrl(this.props.getProperty("url"));
        hikariConfig.setUsername(this.props.getProperty("username"));
        hikariConfig.setPassword(this.props.getProperty("password"));
        hikariConfig.setReadOnly(false);
        hikariConfig.setConnectionTimeout(60000L);
        hikariConfig.setIdleTimeout(60000L);
        hikariConfig.setValidationTimeout(3000L);
        hikariConfig.setMaxLifetime(60000L);
        hikariConfig.setMaximumPoolSize(1000);
        hikariConfig.setMinimumIdle(10);

        return new HikariDataSource(hikariConfig);
    }
}
