package com.bailuntec.job;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.bailuntec.domain.entity.DcBaseCompanyAccount;
import com.bailuntec.domain.example.DcBaseCompanyAccountExample;
import com.bailuntec.domain.pojo.AccountResult;
import com.bailuntec.domain.pojo.CompanyAccountInfo;
import com.bailuntec.mapper.DcBaseCompanyAccountMapper;
import com.bailuntec.utils.OkHttpUtil;
import com.bailuntec.utils.PropertiesUtil;
import com.bailuntec.utils.SessionUtil;
import com.dangdang.ddframe.job.api.ShardingContext;
import com.dangdang.ddframe.job.api.simple.SimpleJob;
import lombok.extern.slf4j.Slf4j;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.ibatis.session.SqlSession;

import java.time.LocalDateTime;

@Slf4j
public class CompanyAccountSyncJob implements SimpleJob {

    private PropertiesUtil propertiesUtil = PropertiesUtil.getInstance("const");
    private OkHttpClient client = OkHttpUtil.getInstance();

    @Override
    public void execute(ShardingContext shardingContext) {

        Request request = new Request.Builder()
                .url(propertiesUtil.getPropertyAsString("COMPANY_ACCOUNT_URL"))
                .get()
                .addHeader("Content-Type", "application/json")
                .build();

        log.info("开始同步百伦帐号信息");

        log.info("请求百伦pams api 开始");
        try (Response response = client.newCall(request).execute();
             SqlSession sqlSession = SessionUtil.getFactory().openSession(true)) {

            log.info("请求百伦pams api 开始结束");

            DcBaseCompanyAccountMapper dcBaseCompanyAccountMapper = sqlSession.getMapper(DcBaseCompanyAccountMapper.class);
            String resultStr = response.body().string();

            AccountResult<CompanyAccountInfo> companyAccountInfoResult = JSONObject.parseObject(resultStr, new TypeReference<AccountResult<CompanyAccountInfo>>() {
            });

            /*同步前禁用所有帐号*/
            dcBaseCompanyAccountMapper.updateSetStatusOff();
            for (CompanyAccountInfo companyAccountInfo : companyAccountInfoResult.getData()) {
                DcBaseCompanyAccount dcBaseCompanyAccount = dcBaseCompanyAccountMapper.selectOneByExample(DcBaseCompanyAccountExample.newAndCreateCriteria()
                        .andAccountIdEqualTo(companyAccountInfo.getAccountId())
                        .andCompanyIdEqualTo(companyAccountInfo.getCompanyId())
                        .example());

                if (dcBaseCompanyAccount == null) {
                    dcBaseCompanyAccount = new DcBaseCompanyAccount();
                    dcBaseCompanyAccount.setBjCreate(LocalDateTime.now());
                }
                BeanUtils.copyProperties(dcBaseCompanyAccount, companyAccountInfo);
                dcBaseCompanyAccount.setBjModified(LocalDateTime.now());
                dcBaseCompanyAccountMapper.upsert(dcBaseCompanyAccount);
                log.info("同步百伦帐号信息成功：{}", JSON.toJSONString(dcBaseCompanyAccount));
            }

        } catch (Exception ex) {
            log.error("同步百伦帐号信息成功失败:{}", ex.getMessage(), ex);
        }
    }
}
