package com.bailuntec.domain.pojo;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/8/24 10:29 上午
 */
public class AmazonURI {


    public static final URI NA_AMAZON_AD_URL = URI.create("https://advertising-api.amazon.com");
    public static final URI EU_AMAZON_AD_URL = URI.create("https://advertising-api-eu.amazon.com");
    public static final URI FE_AMAZON_AD_URL = URI.create("https://advertising-api-fe.amazon.com");

    public static final Map<String, URI> amazonUriMap = new HashMap<>();

    public static URI getAmazonAdSiteUri(String siteEn) {
        switch (siteEn.toUpperCase()) {
            case "UK":
            case "FR":
            case "IT":
            case "ES":
            case "DE":
                return EU_AMAZON_AD_URL;
            case "AU":
            case "JP":
            case "IN":
                return FE_AMAZON_AD_URL;
            case "US":
            case "CA":
            case "MX":
            default:
                return NA_AMAZON_AD_URL;
        }
    }
}
