package com.bailuntec.balancesheet.mapper;

import com.bailuntec.balancesheet.dto.CostDTO;
import org.apache.ibatis.annotations.*;
import org.springframework.stereotype.Repository;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@Repository
public interface DcBaseCostMapper {

    @Insert("<script>" +
            "insert into dc_base_cost(cost_no,company_no,company_name,type_no,type_name,subject_code,kind_no,kind_name,create_usercode,create_username,cost_remark," +
            "create_time,son_cost_no,sup_cost_no,cost_status,file_path,mor_file_path,amount,create_userid,sub_logistics_supplier_id,logistics_supplier_id," +
            "bank_name,bank_card,bank_card_user,mor_remark,cost_form,cost_reason,is_lend,had_pay,lend_status,compensate,counteract,lend_balance,reject_reason," +
            "bank_company,cost_plan_no,dic,pay_counteract,pay_lend_balance,pay_plan_amount,pay_dic,pay_cur,is_tax,detail_key,pay_user_id,pay_time,amount_rmb,to_rmb_rate," +
            "company_value,audit_time,day) values" +
            "<foreach collection='list' item='item' index='index' separator=','>" +
            "(#{item.costNo},#{item.companyNo},#{item.companyName},#{item.typeNo},#{item.typeName},#{item.subjectCode},#{item.kindNo},#{item.kindName}," +
            "#{item.createUsercode},#{item.createUsername},#{item.costRemark},#{item.createTime},#{item.sonCostNo},#{item.supCostNo}," +
            "#{item.costStatus},#{item.filePath},#{item.morFilePath},#{item.amount},#{item.createUserid},#{item.subLogisticsSupplierId}," +
            "#{item.logisticsSupplierId},#{item.bankName},#{item.bankCard},#{item.bankCardUser},#{item.morRemark},#{item.costForm},#{item.costReason}," +
            "#{item.isLend},#{item.hadPay},#{item.lendStatus},#{item.compensate},#{item.counteract},#{item.lendBalance}," +
            "#{item.rejectReason},#{item.bankCompany},#{item.costPlanNo},#{item.dic},#{item.payCounteract},#{item.payLendBalance}," +
            "#{item.payPlanAmount},#{item.payDic},#{item.payCur},#{item.isTax},#{item.detailKey},#{item.payUserId},#{item.payTime},#{item.amountRmb}," +
            "#{item.toRmbRate},#{item.companyValue},#{item.auditTime},#{lastDay})" +
            "</foreach>" +
            "</script>")
    void insertDcBaseCost(@Param("list") List<CostDTO> costDTOList, @Param("lastDay") Date lastDay);

    @Delete("delete c from dc_base_cost c inner join dc_company_main_body b on c.company_value = b.company_value and b.no_other_pay_recieve = 1 " +
            "where c.day = #{lastDay}")
    void deleteUnusedCost(@Param("lastDay") Date lastDay);

    /**
     * 标记某天的待出纳支付状态的付款单为待冲销
     * @param lastDay
     */
    @Update("update dc_base_cost set is_wait_pay = 1 where day = #{lastDay} and cost_form = 1 and cost_status = 2")
    void signNoPayCost(@Param("lastDay") Date lastDay);

    /**
     * 标记完成支付的待出纳支付状态的付款单为已冲销
     * @param costNoList
     */
    @Update("<script>" +
            "update dc_base_cost set is_wait_pay = 0 where cost_no in" +
            "<foreach collection='list' item='costNo' index='index' open='(' close=')' separator=','>" +
            "#{costNo}" +
            "</foreach>" +
            "</script>")
    void signNoPayCostToPaid(@Param("list") List<String> costNoList);

    /**
     * 查询所有待出纳支付状态的付款单号
     * @return
     */
    @Select("select cost_no from dc_base_cost where is_wait_pay = 1")
    List<String> getNoPayCostNo();

    /**
     * 已完成状态借支单金额总和
     * @param companyValue
     * @param lastDay
     * @return
     */
    @Select("select sum(amount_rmb) from dc_base_cost where company_value = #{companyValue} and day = #{lastDay} and cost_form = 3 and is_lend = 1 and cost_status = 4")
    BigDecimal getLendCostAmountSum(@Param("companyValue") Integer companyValue, @Param("lastDay") Date lastDay);

    /**
     * 已完成状态借还单金额总和
     * @param companyValue
     * @param lastDay
     * @return
     */
    @Select("select sum(amount_rmb) from dc_base_cost where company_value = #{companyValue} and day = #{lastDay} and cost_form = 3 and is_lend = 2 and cost_status = 4")
    BigDecimal getLendBackCostAmountSum(@Param("companyValue") Integer companyValue, @Param("lastDay") Date lastDay);

    /**
     * 已完成状态所有费用类型付款单金额总和
     * @param companyValue
     * @param lastDay
     * @return
     */
    @Select("select sum(amount_rmb) from dc_base_cost where company_value = #{companyValue} and day = #{lastDay} and cost_form = 1 and cost_status = 4")
    BigDecimal getPayCostAmountSum(@Param("companyValue") Integer companyValue, @Param("lastDay") Date lastDay);

    /**
     * 待出纳付款状态的所有费用类型付款单、已完成状态的费用类型为"借款-其他应付款"和"收款-其他应付款"的还款单的金额总和
     * @param companyValue
     * @param lastDay
     * @return
     */
    @Select("select sum(a.amount_rmb) from (select amount_rmb from dc_base_cost where company_value = #{companyValue} and day = #{lastDay} and cost_form = 1 and cost_status = 2 " +
            "union select amount_rmb from dc_base_cost where company_value = #{companyValue} and day = #{lastDay} and cost_form = 2 and cost_status = 4 " +
            "and kind_name in ('借款--其他应付款','收款--其他应付款')) a")
    BigDecimal getReceiveAndNoPayCostAmountSum(@Param("companyValue") Integer companyValue, @Param("lastDay") Date lastDay);
}

