package com.bailuntec.job;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.bailuntec.domain.entity.DcBasePaypalAccount;
import com.bailuntec.domain.entity.JobPointLog;
import com.bailuntec.domain.example.DcBasePaypalAccountExample;
import com.bailuntec.domain.pojo.AccountResult;
import com.bailuntec.domain.pojo.PaypalAccountInfo;
import com.bailuntec.mapper.DcBasePaypalAccountMapper;
import com.bailuntec.support.PointJob;
import com.bailuntec.utils.OkHttpUtil;
import com.bailuntec.utils.PropertiesUtil;
import com.bailuntec.utils.SessionUtil;
import com.dangdang.ddframe.job.api.ShardingContext;
import lombok.extern.slf4j.Slf4j;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.StringUtils;

import java.io.IOException;
import java.util.List;

@Slf4j
public class PaypalAccountSyncJob extends PointJob {

    private PropertiesUtil propertiesUtil = PropertiesUtil.getInstance("const");
    private OkHttpClient client = OkHttpUtil.getInstance();

    @Override
    public void executeJob(ShardingContext shardingContext, JobPointLog jobPointLog) {
        Request request = new Request.Builder()
                .url(propertiesUtil.getPropertyAsString("PAYPAL_ACCOUNT_URL"))
                .get()
                .addHeader("Content-Type", "application/json")
                .build();
        Response response = null;
        String resultStr = null;
        try {
            response = client.newCall(request).execute();
            resultStr = response.body().string();
        } catch (IOException e) {
            throw new RuntimeException("调用paypal账户授权信息接口失败", e);
        } finally {
            if (response != null) {
                response.close();
            }
        }
        if (StringUtils.isNotBlank(resultStr)) {
            AccountResult<PaypalAccountInfo> paypalAccountInfoResult = JSONObject.parseObject(resultStr, new TypeReference<AccountResult<PaypalAccountInfo>>(){});
            if (paypalAccountInfoResult.getSuccess()!= null && paypalAccountInfoResult.getSuccess()) {
                List<PaypalAccountInfo> result = paypalAccountInfoResult.getData();
                if (result != null && result.size() > 0) {
                    DcBasePaypalAccountMapper mapper = SessionUtil.getSession().getMapper(DcBasePaypalAccountMapper.class);
                    DcBasePaypalAccount dcBasePaypalAccount = new DcBasePaypalAccount();
                    try {
                        for (PaypalAccountInfo paypalAccountInfo : result) {
                            BeanUtils.copyProperties(paypalAccountInfo, dcBasePaypalAccount);
                            dcBasePaypalAccount.setId(null);
                            int i = mapper.updateByExampleSelective(dcBasePaypalAccount, DcBasePaypalAccountExample.newAndCreateCriteria().andPaypalIdEqualTo(dcBasePaypalAccount.getPaypalId()).example());
                            if (i == 0) {
                                mapper.insertSelective(dcBasePaypalAccount);
                            }
                        }
                    } catch (Exception e) {
                        throw new RuntimeException("Mybatis操作DB失败",e);
                    } finally {
                        SessionUtil.closeSession();
                    }
                }
            } else {
                throw new RuntimeException("调用公司账户授权信息接口返回错误");
            }
        } else {
            throw new RuntimeException("调用公司账户授权信息接口返回null");
        }
    }
}
