package com.bailuntec.domain.enumerate;

public enum OrderExceptionType {
    SkuMapLost(1,"SkuMapLost"),//Sku映射缺失
    ReceiptAddressError(2,"ReceiptAddressError"),//地址识别异常
    BuyerRemark(3,"BuyerRemark"),//顾客留言
    LogisticsUnknown(4,"LogisticsUnknown"),//无匹配物流规则
    WareHouseUnknown(5,"WareHouseUnknown"),//无匹配仓库规则
    BailunOrder(6,"BailunOrder"),//订单问题规则
    EbaySpecific(7,"EbaySpecific"),//Ebay特有异常
    PickingApply(8,"PickingApply"),//配货拦截
    PlatSkuRemark(9,"PlatSkuRemark"),//产品备注
    StopPicking(10,"StopPicking"),//人为暂停配货
    SpecifiedLogisticsUnVerify(11,"SpecifiedLogisticsUnVerify"),//指定物流不可用
    NoValidLogistics(12,"NoValidLogistics"),//物流配置限制不可用
    NoValidWarehouse(13,"NoValidWarehouse"),//无该区域发货仓库
    Scalp(14,"Scalp"),//刷单异常
    ReceivierPhoneError(15,"ReceivierPhoneError"),//电话/联系人异常
    Huanqiu(23,"Huanqiu");//环球未配货

    private final int code;
    private final String value;


    OrderExceptionType(int code, String value) {
        this.code = code;
        this.value = value;
    }

    public String value() {
        return value;
    }

    public int code() {
        return code;
    }
}
