package com.bailuntec.domain.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 销量预测配置表
 * </p>
 *
 * @author robbendev
 * @since 2020-08-13
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value="DcAutoSalesForecastConfig对象", description="销量预测配置表")
public class DcAutoSalesForecastConfig implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "规则描述")
    private String title;

    @ApiModelProperty(value = "仓库类型，可以留空 例：中国仓, dc_base_warehouse.hq_type")
    private String warehouseType;

    @ApiModelProperty(value = "国家，可以留空 例：美国，dc_base_warehouse.area_id")
    private String warehouseAreaId;

    @ApiModelProperty(value = "仓库编码，可以留空 dc_base_warehouse.warehouse_code ")
    private String warehouseCode;

    @ApiModelProperty(value = "类目，例：推荐普货 dc_base_sku.product_type")
    private String category;

    @ApiModelProperty(value = "一个sku 同时命中多条规则时，数字越大优先")
    private Integer level;

    @ApiModelProperty(value = "是否作废 1-作废 0-正常")
    private Integer isDelete;

    @ApiModelProperty(value = "创建时间")
    private LocalDateTime createDate;

    @ApiModelProperty(value = "筛选类型 1 =根据入库时间筛选 2 = 根据销量筛选")
    private Integer screenType;

    @ApiModelProperty(value = "作废时间")
    private LocalDateTime deleteTime;


}
