import com.bailuntec.domain.entity.JobAccountLog;
import com.bailuntec.domain.entity.JobAmazonAdLog;
import com.bailuntec.domain.entity.JobPointLog;
import com.bailuntec.domain.example.JobAmazonAdLogExample;
import com.bailuntec.job.AmazonAdDownloadReportJob;
import com.bailuntec.job.AmazonAdGenerateReportIdJob;
import com.bailuntec.mapper.JobAmazonAdLogMapper;
import com.bailuntec.utils.SessionUtil;
import com.dangdang.ddframe.job.api.ShardingContext;
import com.dangdang.ddframe.job.executor.ShardingContexts;
import lombok.extern.slf4j.Slf4j;
import org.junit.jupiter.api.Test;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;

@Slf4j
public class AmazonAdProductTest {

    @Test
    public void test() throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException, InstantiationException {
        Class clazz = Class.forName("com.bailuntec.job.AmazonAdGenerateReportIdJob");
        Method generateReportId = clazz.getDeclaredMethod("generateReportId", JobAccountLog.class);
        generateReportId.setAccessible(true);
        JobAccountLog jobAccountLog = new JobAccountLog();
        jobAccountLog.setStartTime(LocalDateTime.of(2020, 8, 17, 0, 0));
        jobAccountLog.setEndTime(LocalDateTime.of(2020, 8, 18, 0, 0));
        jobAccountLog.setCompanyId(1);
        jobAccountLog.setAccountId(1779);
        jobAccountLog.setIntervalTime(1);
        jobAccountLog.setJobName("base-amazon-ad-product-generate");
        generateReportId.invoke(clazz.newInstance(), jobAccountLog);
    }

    @Test
    public void test2() throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException, InstantiationException {
        Class clazz = Class.forName("com.bailuntec.job.AmazonAdDownloadReportJob");
        Method generateReportId = clazz.getDeclaredMethod("downloadReport", JobAmazonAdLog.class);
        int pageSize = 10;
        generateReportId.setAccessible(true);
        try {
            JobAmazonAdLogMapper mapper = SessionUtil.getSession().getMapper(JobAmazonAdLogMapper.class);
            List<JobAmazonAdLog> jobAmazonAdLogList = mapper.selectByExample(JobAmazonAdLogExample.newAndCreateCriteria()
                    .andStatusEqualTo(false)
                    .andBjModifiedLessThan(LocalDateTime.now().minusMinutes(15))
                    .example()
                    .orderBy("id")
                    .limit(0, pageSize));

            if (jobAmazonAdLogList != null && !jobAmazonAdLogList.isEmpty()) {
                for (JobAmazonAdLog jobAmazonAdLog : jobAmazonAdLogList) {
                    generateReportId.invoke(clazz.newInstance(), jobAmazonAdLog);
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            SessionUtil.closeSession();
        }
    }

    @Test
    public void test3() throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException, InstantiationException {
        Class clazz = Class.forName("com.bailuntec.job.AmazonAdDownloadReportJob");
        Method generateReportId = clazz.getDeclaredMethod("downloadReport", JobAmazonAdLog.class);
        int pageSize = 1;
        generateReportId.setAccessible(true);
        try {
            JobAmazonAdLogMapper mapper = SessionUtil.getSession().getMapper(JobAmazonAdLogMapper.class);
            List<JobAmazonAdLog> jobAmazonAdLogList = mapper.selectByExample(JobAmazonAdLogExample
                    .newAndCreateCriteria()
                    .andStatusEqualTo(false)
                    .andIdEqualTo(1969)
                    .andBjModifiedLessThan(LocalDateTime.now().minusMinutes(15))
                    .example()
                    .orderBy("id")
                    .limit(0, pageSize));

            if (jobAmazonAdLogList != null && !jobAmazonAdLogList.isEmpty()) {
                for (JobAmazonAdLog jobAmazonAdLog : jobAmazonAdLogList) {
                    generateReportId.invoke(clazz.newInstance(), jobAmazonAdLog);
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            SessionUtil.closeSession();
        }
    }


    @Test
    public void unDownload() {
        JobAmazonAdLogMapper jobAmazonAdLogMapper = SessionUtil.getSession().getMapper(JobAmazonAdLogMapper.class);
        AmazonAdDownloadReportJob amazonAdDownloadReportJob = new AmazonAdDownloadReportJob();


        jobAmazonAdLogMapper.selectByExample(JobAmazonAdLogExample.newAndCreateCriteria()
                .andStatusEqualTo(false)
                .example())
                .forEach(jobAmazonAdLog -> {
                    amazonAdDownloadReportJob.downloadReport(jobAmazonAdLog, null);
                });
    }

    @Test
    public void testReport() {
        AmazonAdGenerateReportIdJob amazonAdGenerateReportIdJob = new AmazonAdGenerateReportIdJob();
        AmazonAdDownloadReportJob amazonAdDownloadReportJob = new AmazonAdDownloadReportJob();


        amazonAdGenerateReportIdJob.executeJob(new ShardingContext(
                new ShardingContexts(null, "amazonAdGenerateReportIdJob", 1, null, new HashMap<>()), 0
        ), new JobPointLog("amazonAdGenerateReportIdJob",
                1,
                100,
                null,
                1,
                LocalDateTime.of(2020, 4, 1, 0, 0),
                LocalDateTime.of(2020, 4, 2, 0, 0)));


        amazonAdDownloadReportJob.execute(new ShardingContext(
                new ShardingContexts(null, "amazonAdDownloadReportJob", 1, null, new HashMap<>()), 0
        ));
    }
}
