import com.alibaba.fastjson.JSON;
import com.bailuntec.domain.entity.JobPointLog;
import com.bailuntec.domain.example.JobPointLogExample;
import com.bailuntec.domain.pojo.OmsResultInfo;
import com.bailuntec.domain.pojo.OmsResultRoot;
import com.bailuntec.job.OrderSyncJob;
import com.bailuntec.mapper.JobPointLogMapper;
import com.bailuntec.utils.OkHttpUtil;
import com.bailuntec.utils.SessionUtil;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;
import org.junit.jupiter.api.Test;

import java.io.IOException;
import java.util.LinkedHashMap;

public class OmsOrderTest {


    @Test
    public void test1() {
        OkHttpClient okHttpClient = OkHttpUtil.getInstance();
        LinkedHashMap<String, String> map = new LinkedHashMap<>(4);
        map.put("pageIndex", "1");
        map.put("pageCount", "100");
        map.put("BailunLastUpdateTimeFrom", "2019-02-28 13:38:02");
        map.put("BailunLastUpdateTimeTo", "2019-02-28 14:32:14");
        Request request = new Request.Builder()
                .get()
                .url(OkHttpUtil.attachHttpGetParams("http://oms.bailuntec.com/apiV2/bailunOrder/getBailunOrders", map))
                .addHeader("Content-Type", "application/json")
                .build();
        Response response = null;
        String omsResultStr = null;
        try {
            response = okHttpClient.newCall(request).execute();
            omsResultStr = response.body().string();
        } catch (IOException e) {
            throw new RuntimeException(map + "请求OMS接口同步百伦接口失败" + response, e);
        } finally {
            if (response != null) {
                response.close();
            }
        }
        OrderSyncJob orderSyncJob = new OrderSyncJob();
        if (StringUtils.isNoneBlank(omsResultStr)) {
            OmsResultRoot omsResultRoot = JSON.parseObject(omsResultStr, OmsResultRoot.class);
            if (omsResultRoot != null && omsResultRoot.getSuccess().booleanValue()) {
                OmsResultInfo omsResultInfo = omsResultRoot.getResult();
                if (omsResultInfo.getResult() != null && omsResultInfo.getResult().size() > 0) {
                    orderSyncJob.analyseOmsOrder(omsResultInfo.getResult());
                }
            } else {
                throw new RuntimeException("调用OMS接口同步百伦订单失败, 响应200, 请求参数" + map.toString());
            }
        }
    }
    @Test
    public void test4() {
        OrderSyncJob orderSyncJob = new OrderSyncJob();
        JobPointLog jobPointLog = null;
        try {
            JobPointLogMapper mapper = SessionUtil.getSession().getMapper(JobPointLogMapper.class);
            jobPointLog = mapper.selectOneByExample(JobPointLogExample.newAndCreateCriteria().andJobNameEqualTo("base-sync-oms-order").example());
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            SessionUtil.closeSession();
        }
        orderSyncJob.executeJob(null, jobPointLog);
    }

    @Test
    public void test() {
        OkHttpClient okHttpClient = OkHttpUtil.getInstance();
        LinkedHashMap<String, String> map = new LinkedHashMap<>(4);
        map.put("pageIndex", "1");
        map.put("pageCount", "100");
        map.put("OriginOrderNo", "263334209922-2394744359016");
        Request request = new Request.Builder()
                .get()
                .url(OkHttpUtil.attachHttpGetParams("http://oms.bailuntec.com/apiV2/bailunOrder/getBailunOrders", map))
                .addHeader("Content-Type", "application/json")
                .build();
        Response response = null;
        String omsResultStr = null;
        try {
            response = okHttpClient.newCall(request).execute();
            omsResultStr = response.body().string();
        } catch (IOException e) {
            throw new RuntimeException(map + "请求OMS接口同步百伦接口失败" + response, e);
        } finally {
            if (response != null) {
                response.close();
            }
        }
        OrderSyncJob orderSyncJob = new OrderSyncJob();
        if (StringUtils.isNoneBlank(omsResultStr)) {
            OmsResultRoot omsResultRoot = JSON.parseObject(omsResultStr, OmsResultRoot.class);
            if (omsResultRoot != null && omsResultRoot.getSuccess().booleanValue()) {
                OmsResultInfo omsResultInfo = omsResultRoot.getResult();
                if (omsResultInfo.getResult() != null && omsResultInfo.getResult().size() > 0) {
                    orderSyncJob.analyseOmsOrder(omsResultInfo.getResult());
                }
            } else {
                throw new RuntimeException("调用OMS接口同步百伦订单失败, 响应200, 请求参数" + map.toString());
            }
        }
    }
}
