package com.blt.other.module.supplier.service.impl;

import com.blt.other.module.database.model.SupplierDomain;
import com.blt.other.module.supplier.dao.SupplierDao;
import com.blt.other.module.supplier.service.SupplierSearchService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class SupplierSearchServiceImpl implements SupplierSearchService {

    @Autowired
    private SupplierDao supplierDao;

    @Override
    public List<SupplierDomain> getByKey(String key) { return supplierDao.selectByKey(key); }

    @Override
    public SupplierDomain getBySupplierNo(String supplierNo) {
        return supplierDao.selectBySupplierNo(supplierNo);
    }
}
