package com.blt.other.module.sku.service;

import com.blt.other.module.database.model.SysProductDomain;

import java.util.List;
import java.util.Map;

public interface SysProductService {

    /**
     * 获取所有 sku 列表
     * @return
     */
    List<SysProductDomain> getAllSku();

    /**
     * 分页获取所有 sku 列表
     * @return
     */
    Map<String,Object> getAllSkuByPage(Integer pageNum,Integer pageSize);

    /**
     * 根据查询关键字获取 sku
     * @param keyword
     * @return
     */
    List<SysProductDomain> getSkuByKeyword(String keyword);

    /**
     * 新增 sku
     * @param sku
     * @return
     */
    SysProductDomain save(SysProductDomain sku);

    /**
     * 根据 skucode 获取 sku 信息
     * @param skucode
     * @return
     */
    SysProductDomain getSkuBySkucode(String skucode);

    /**
     * 删除 sku
     * @param skucode
     * @return
     */
    Integer deleteSku(String skucode);

    Integer update(SysProductDomain object);
}
