package com.blt.other.module.auth.controller;

import com.bailuntec.cost.api.response.CostResult;
import com.blt.other.module.auth.service.UserService;
import com.blt.other.module.auth.service.UserSyncService;
import com.blt.other.module.auth.vo.GetByBLUserAcct;
import com.blt.other.module.auth.vo.UserGetByBLUserAcct;
import com.blt.other.common.util.AxiosUtil;
import com.blt.other.module.database.model.BuyUserDomain;
import com.blt.other.module.database.model.UserDomain;
import com.blt.other.module.supplier.service.BuyUserService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Api(tags = "费用系统用户接口")
@RestController
@RequestMapping(value = "/user")
public class UserController {

    private static Logger logger = LoggerFactory.getLogger(UserController.class);

    @Autowired
    private UserService userService;
    @Autowired
    private UserSyncService userSyncService;
    @Autowired
    private BuyUserService buyUserService;

    @Value("${cookie.domain.fee}")
    private String feeDomain;

    @PostMapping("getOne")
    public UserDomain getOneByuserCode(@RequestParam String usercode) {
        UserDomain user = userService.findOne(usercode);
        return user;
    }

    @GetMapping("/getAllUser")
    public List<UserDomain> getAllUser(HttpServletResponse response, HttpServletRequest request) {
        List<UserDomain> allUser = userService.findAllUser();
        return allUser;
    }

    /**
     * 通过 cookie 获取并保存用户信息
     *
     * @param request
     * @return
     */
    @GetMapping("getUserMsg")
    public GetByBLUserAcct getUserMsg(HttpServletRequest request, HttpServletResponse response) {
        AxiosUtil.setCors(response, request);

        GetByBLUserAcct userByCookie = userSyncService.getUserByCookie(request);
        if (null == userByCookie) {
            delCookie(response);
            return null;
        }
        UserGetByBLUserAcct data = userByCookie.getData();
        Integer integer = userService.saveUser(data);
        return userByCookie;
    }

    @PostMapping("/addUserMsg")
    public Map<String, Object> addUserMsg(HttpServletRequest request, HttpServletResponse response, UserDomain userDomain) {
        AxiosUtil.setCors(response, request);
        Map<String, Object> map = new HashMap<>();
        UserDomain oldUser = userService.findByUserid(userDomain.getUserid());
        if (oldUser != null) {
            int num = userService.updateUser(userDomain);
        } else {
            logger.warn("新增用户，用户信息：" + userDomain.toString());
            userDomain.setCreatetime(new Date());
            userDomain.setIsadmin(0);
            userDomain.setIsfinansys(0);
            userService.insertUser(userDomain);
        }
        map.put("success", true);
        return map;
    }

    @PostMapping("/getUserMsgByCode")
    public UserDomain getUserMsgByCode(HttpServletResponse response, HttpServletRequest request) {
        AxiosUtil.setCors(response, request);
        String usercode = request.getParameter("usercode");
        UserDomain one = userService.findOne(usercode);
        return one;
    }

    @PostMapping("/getUserMsgByUserid")
    public UserDomain getUserMsgByUserid(@RequestParam Integer userid) {
        return userService.findByUserid(userid);
    }

    @PostMapping("/submitEdit")
    public UserDomain submitEdit(HttpServletResponse response, HttpServletRequest request) {
        AxiosUtil.setCors(response, request);
        String userid = request.getParameter("userid");
        String isadminStr = request.getParameter("isadmin");
        String isfinansysStr = request.getParameter("isfinansys");
        String authority = request.getParameter("authority");
        UserDomain user = new UserDomain();
        user.setUserid(Integer.parseInt(userid));
        user.setIsadmin(Integer.parseInt(isadminStr));
        user.setIsfinansys(Integer.parseInt(isfinansysStr));
        user.setAuthority(authority);
        Integer result = userService.updateUser(user);
        return user;
    }

    @PostMapping("/getByKey")
    public List<UserDomain> getByKey(HttpServletResponse response, HttpServletRequest request) {
        AxiosUtil.setCors(response, request);
        String key = request.getParameter("key");
        return userService.getListByKey(key);
    }

    @GetMapping("/getAdmins")
    public List<UserDomain> getAdmins(HttpServletResponse response, HttpServletRequest request) {
        AxiosUtil.setCors(response, request);
        return userService.getAllAdmins();
    }

    @GetMapping("/getFinansys")
    public List<UserDomain> getFinansys(HttpServletResponse response, HttpServletRequest request) {
        AxiosUtil.setCors(response, request);
        return userService.getAllFinansys();
    }

    @GetMapping("/getSupAdmins")
    public List<UserDomain> getSupAdmins(HttpServletResponse response, HttpServletRequest request) {
        AxiosUtil.setCors(response, request);
        return userService.getAllSupAdmins();
    }

    @GetMapping("/getOaUserList")
    public List<BuyUserDomain> getOaUserList(HttpServletResponse response, HttpServletRequest request) {
        AxiosUtil.setCors(response, request);
        return buyUserService.getBuyUserList();
    }

    @PostMapping("/submitAdd")
    public Map<String, Object> submitAdd(HttpServletResponse response, HttpServletRequest request) {
        AxiosUtil.setCors(response, request);
        Map<String, Object> map = new HashMap<>();
        String userid = request.getParameter("userid");
        UserDomain byUserid = userService.findByUserid(Integer.parseInt(userid));
        if (null != byUserid) {
            map.put("success", false);
            map.put("msg", "用户信息已存在，请勿重复添加");
            return map;
        }

        String isadminStr = request.getParameter("isadmin");
        String isfinansysStr = request.getParameter("isfinansys");
        UserDomain user = new UserDomain();
        user.setUserid(Integer.parseInt(userid));
        user.setIsadmin(Integer.parseInt(isadminStr));
        user.setIsfinansys(Integer.parseInt(isfinansysStr));

        List<BuyUserDomain> buyUserList = buyUserService.getBuyUserList();
        if (null != buyUserList && buyUserList.size() >= 1) {
            for (BuyUserDomain oaUser : buyUserList) {
                if (Integer.parseInt(userid) == oaUser.getUserid()) {
                    user.setUsername(oaUser.getUsername());
                }
            }
        }
        userService.save(user);
        map.put("success", true);
        return map;
    }

    @GetMapping("/outLogin")
    public Map<String, Object> outLogin(HttpServletResponse response, HttpServletRequest request) {
        AxiosUtil.setCors(response, request);
        delCookie(response);
        Map<String, Object> map = new HashMap<>();
        map.put("success", true);
        return map;
    }

    @PostMapping("/deleteUser")
    public Map<String, Object> deleteUser(HttpServletResponse response, HttpServletRequest request) {
        AxiosUtil.setCors(response, request);
        String userid = request.getParameter("userid");
        Map<String, Object> map = new HashMap<>();
        Integer result = userService.deleteUser(Integer.parseInt(userid));
        if (null != result && result == 1) {
            map.put("success", true);
        }
        return map;
    }

    private void delCookie(HttpServletResponse response) {
        Cookie baiLunLoginUserKey = new Cookie("BaiLunLoginUserKey", "baiLunLoginUserKey");
        baiLunLoginUserKey.setPath("/");
        baiLunLoginUserKey.setDomain(feeDomain);
        baiLunLoginUserKey.setMaxAge(0);
        response.addCookie(baiLunLoginUserKey);
        Cookie bLUserAcct = new Cookie("BLUserAcct", "bLUserAcct");
        bLUserAcct.setPath("/");
        bLUserAcct.setDomain(feeDomain);
        bLUserAcct.setMaxAge(0);
        response.addCookie(bLUserAcct);
    }

    @ApiOperation("根据百伦一级部门id查找费用系统用户列表")
    @GetMapping("/getByPrimaryDepartmentId")
    public CostResult<List<UserDomain>> getByPrimaryDepartmentId(@RequestParam Integer primaryDepartmentId) {
        List<UserDomain> userDomainList = userService.getByPrimaryDepartmentId(primaryDepartmentId);
        return CostResult.success(userDomainList);
    }

    @ApiOperation("根据百伦公司主体id查找费用系统用户列表")
    @GetMapping("/getByCompanyId")
    public CostResult<List<UserDomain>> getByCompanyId(@RequestParam Integer companyId) {
        List<UserDomain> userDomainList = userService.getByCompanyId(companyId);
        return CostResult.success(userDomainList);
    }
}
