package com.blt.other.cost.dao;

import com.blt.other.database.model.CostCompanyDomain;
import org.apache.ibatis.annotations.Mapper;
import org.springframework.stereotype.Repository;

import java.util.List;

@Mapper
@Repository
public interface CostCompanyDao {

    /**
     * 添加主体
     * @param costCompanyDomain
     * @return
     */
    Integer insertCompany(CostCompanyDomain costCompanyDomain);

    /**
     * 通过主体名称获取主体
     * @param costCompanyDomain
     * @return
     */
    List<CostCompanyDomain> selectByNameOrValue(CostCompanyDomain costCompanyDomain);

    /**
     * 通过 companyNo 获取主体
     * @param no
     * @return
     */
    CostCompanyDomain selectByNo(String no);

    /**
     * 通过 companyNo 修改主体信息
     * @param costCompanyDomain
     * @return
     */
    Integer update(CostCompanyDomain costCompanyDomain);

    /**
     * 获取所有主体列表
     * @return
     */
    List<CostCompanyDomain> selectAll();

    List<CostCompanyDomain> getAllCompanyAuthority();

    /**
     * 根据主体名获取主体
     * @param companyName
     * @return
     */
    CostCompanyDomain selectByName(String companyName);
}
