package com.blt.other.cost.controller;

import com.blt.other.commons.utils.AxiosUtil;
import com.bailuntec.cost.api.dto.CostTypeDto;
import com.bailuntec.cost.api.dto.CostTypeKindDto;
import com.blt.other.cost.service.CostCompanyService;
import com.blt.other.cost.service.CostTypeKindService;
import com.blt.other.cost.service.CostTypeService;
import com.blt.other.database.model.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 费用类型管理控制器
 */
@RestController
@RequestMapping("cost/type")
public class CostTypeController {
    private static Logger logger = LoggerFactory.getLogger(CostTypeController.class);

    @Autowired
    private CostCompanyService costCompanyService;

    @Autowired
    private CostTypeKindService costTypeKindService;

    @Autowired
    private CostTypeService costTypeService;



    @Value("${costTypeKind.logisticsSubjectCode}")
    private String logisticsSubjectCode; //物流科目编号

    /**
     * 获取所有公司主题列表
     *
     * @return
     */
    @GetMapping("/getAllCompany")
    public List<CostCompanyDomain> getAllCompany(HttpServletResponse response, HttpServletRequest request) {
        AxiosUtil.setCors(response, request);
        List<CostCompanyDomain> allCompany = costCompanyService.getAllCompany();
        return allCompany;
    }

    @GetMapping("/getAllCompanyAuthority")
    public List<CostCompanyDomain> getAllCompanyAuthority(HttpServletResponse response, HttpServletRequest request) {
        AxiosUtil.setCors(response, request);
        List<CostCompanyDomain> allCompany = costCompanyService.getAllCompanyAuthority();
        return allCompany;
    }

    @GetMapping("/syncAllCompany")
    public Map<String, Object> syncAllCompany(HttpServletResponse response, HttpServletRequest request){
        AxiosUtil.setCors(response, request);
        Map<String, Object> result = new HashMap<>();
        try {
            String syncResult = costCompanyService.syncCompany();
            String msg = "从财务系统同步公司主体数据，" + syncResult;
            result.put("success", true);
            result.put("msg", msg);
        }catch (Exception e){
            logger.error(">>>>>从财务系统同步公司主体数据出错" + e.getMessage());
            result.put("success", false);
        }
        return result;
    }

    @GetMapping("/getAllType")
    public List<CostTypeDomain> getAllType(HttpServletResponse response, HttpServletRequest request) {
        String origin = request.getHeader("Origin");
        response.setHeader("Access-Control-Allow-Origin", origin);
        response.setHeader("Access-Control-Allow-Credentials", "true");
        List<CostTypeDomain> list = costTypeService.getAllType();
        return list;
    }

    /**
     * 添加费用类型
     *
     * @param response
     * @param request
     * @return
     */
    @PostMapping("/postNewType")
    public Map<String, Object> postNewType(HttpServletResponse response, HttpServletRequest request) {
        AxiosUtil.setCors(response,request);

        Map<String, Object> result = new HashMap<>();

        String companyNo = request.getParameter("companyNo");
        String typeName = request.getParameter("typeName");
        String subjectCode = request.getParameter("subjectCode");
        boolean ismanage = Boolean.valueOf(request.getParameter("ismanage"));
        if(ismanage) {
            TypeRelationDomain typeRelationDomain = costTypeService.getTyeRelation(typeName);
            if(typeRelationDomain == null) {
                costTypeService.insertTypeRalation(typeName);
            }
        }
//        String costFormStr = request.getParameter("costForm");
//        Integer costForm = null;
//        try {
//            costForm = Integer.parseInt(costFormStr);
//        } catch (Exception e) {
//            result.put("success", false);
//            result.put("msg", "请选择费用类型");
//            return result;
//        }

        CostTypeDomain costTypeDomain = new CostTypeDomain();
        costTypeDomain.setCompanyNo(companyNo);
        costTypeDomain.setTypeName(typeName);
        costTypeDomain.setSubjectCode(subjectCode);
//        if (3 == costForm){
//            costTypeDomain.setCostForm(3);
//            costTypeDomain.setIsLend(1);
//        }else if (4 == costForm){
//            costTypeDomain.setCostForm(3);
//            costTypeDomain.setIsLend(2);
//        }else {
//            costTypeDomain.setCostForm(costForm);
//        }

        Integer integer = costTypeService.saveNewType(costTypeDomain);
        if (null != integer && integer >= 1) {
            result.put("success", true);
            result.put("msg", "费用类型保存成功");
            logger.warn("费用类型保存成功：" + companyNo + "   " + typeName);
        } else {
            result.put("success", false);
            result.put("msg", "费用类型已存在");
        }
        return result;
    }

    @GetMapping("/getTypeByCompanyNo")
    public List<CostTypeDto> getTypeByCompanyNo(HttpServletResponse response, HttpServletRequest request) {
        AxiosUtil.setCors(response, request);
        String companyNo = request.getParameter("companyNo");
        List<CostTypeDto> list = null;
        if ("allCompany".equals(companyNo)) {
            list = null;
        } else {
            list = costTypeService.getListByCompanyNo(companyNo);
        }
//        logger.warn(AxiosUtil.getOrigin(request) + " ：" + companyNo + " ：" + list);
        return list;
    }

    @GetMapping("/getAllCostKind")
    public Map<String, Object> getAllCostKind(HttpServletResponse response, HttpServletRequest request) {
        AxiosUtil.setCors(response, request);
        String pageNumStr = request.getParameter("pageNum");
        Integer pageNum = Integer.parseInt(pageNumStr);
        String pageSizeStr = request.getParameter("pageSize");
        Integer pageSize = Integer.parseInt(pageSizeStr);

        Map<String, Object> allKindWithPage = costTypeKindService.getAllKindWithPage(pageNum, pageSize);
        allKindWithPage.put("success", true);
        allKindWithPage.put("msg", "");
        return allKindWithPage;
    }

    /**
     * 根据 TypeNo 获取费用种类
     *
     * @param response
     * @param request
     * @return
     */
    @GetMapping("/getKindByTypeNo")
    public List<CostTypeKindDto> getKindByTypeNo(HttpServletResponse response, HttpServletRequest request) {
        AxiosUtil.setCors(response, request);
        String typeNo = request.getParameter("typeNo");
        List<CostTypeKindDto> kindsByTypeNo = null;
        if ("isLendType".equals(typeNo)) {
            kindsByTypeNo = new ArrayList<>();
            CostTypeKindDto isLend1 = new CostTypeKindDto();
            isLend1.setId(-1);
            isLend1.setKindNo("1");
            isLend1.setKindName("借支");
            CostTypeKindDto isLend2 = new CostTypeKindDto();
            isLend2.setId(-2);
            isLend2.setKindNo("2");
            isLend2.setKindName("借还");

            kindsByTypeNo.add(isLend1);
            kindsByTypeNo.add(isLend2);
            return kindsByTypeNo;
        }

        if ("allType".equals(typeNo)) {
            String companyNo = request.getParameter("companyNo");
            if ("allCompany".equals(companyNo)) {
                kindsByTypeNo = costTypeKindService.getAllKind();
            } else {
                kindsByTypeNo = costTypeKindService.getListByCompanyNo(companyNo);
            }
        } else {
            kindsByTypeNo = costTypeKindService.getListByTypeNo(typeNo);
        }
        return kindsByTypeNo;
    }

    @GetMapping("/getKindsByCompanyNo")
    public List<CostTypeKindDto> getKindsByCompanyNo(HttpServletResponse response, HttpServletRequest request) {
        AxiosUtil.setCors(response, request);
        String companyNo = request.getParameter("companyNo");
        List<CostTypeKindDto> kindsByCompanyNo = null;
        if ("allCompany".equals(companyNo)) {
            kindsByCompanyNo = costTypeKindService.getAllKind();
            return kindsByCompanyNo;
        }
        kindsByCompanyNo = costTypeKindService.getListByCompanyNo(companyNo);
        return kindsByCompanyNo;
    }

//    @GetMapping("/getKindsByCompanyNoAndCostForm")
//    public List<CostTypeKindDto> getKindsByCompanyNoAndCostForm(HttpServletResponse response, HttpServletRequest request) {
//        AxiosUtil.setCors(response, request);
//        String companyNo = request.getParameter("companyNo");
//        String costFormStr = request.getParameter("costForm");
//        Integer costForm = Integer.parseInt(costFormStr);
//        List<CostTypeKindDto> kindsByCompanyNo = costTypeKindService.getListByCompanyNoAndCostForm(companyNo, costForm);
//        if (3 == costForm) {
//            String isLendStr = request.getParameter("isLend");
//            Integer isLend = Integer.parseInt(isLendStr);
//            if ((null != kindsByCompanyNo && kindsByCompanyNo.size() >= 1) && (3 == costForm && null != isLend)) {
//                List<CostTypeKindDto> list = new ArrayList<>();
//                for (CostTypeKindDto dtp : kindsByCompanyNo) {
//                    if (3 == dtp.getCostForm() && isLend == dtp.getIsLend()) {
//                        list.add(dtp);
//                    }
//                }
//                return list;
//            }
//        }
//        return kindsByCompanyNo;
//    }

    @GetMapping("/getKindByKindNo")
    public CostTypeKindDomain getKindByKindNo(HttpServletResponse response, HttpServletRequest request) {
        AxiosUtil.setCors(response, request);
        String kindNo = request.getParameter("kindNo");
        CostTypeKindDomain kindByKindNo = costTypeKindService.getKindByKindNo(kindNo);
        return kindByKindNo;
    }

    /**
     * 添加费用小类
     *
     * @param response
     * @param request
     * @return
     */
    @PostMapping("/postNewKind")
    public Map<String, Object> postNewKind(HttpServletResponse response, HttpServletRequest request) {
        AxiosUtil.setCors(response, request);

        String typeNo = request.getParameter("typeNo");
        String kindName = request.getParameter("kindName");
        String createUsername = request.getParameter("createUsername");
        String createUsercode = request.getParameter("createUsercode");

        CostTypeKindDomain costTypeKindDomain = new CostTypeKindDomain();
        costTypeKindDomain.setTypeNo(typeNo);
        costTypeKindDomain.setKindName(kindName);
        costTypeKindDomain.setCreateUsername(createUsername);
        costTypeKindDomain.setCreateUsercode(createUsercode);

        Integer integer = costTypeKindService.saveNewKind(costTypeKindDomain);
        Map<String, Object> result = new HashMap<>();
        if (null != integer && integer >= 1) {
            result.put("success", true);
            result.put("msg", "费用种类保存成功");
            logger.warn("费用种类保存成功：" + typeNo + "   " + kindName);
        } else {
            result.put("success", false);
            result.put("msg", "费用种类已存在");
        }
        return result;
    }

    @GetMapping("/getAllKind")
    public List<CostTypeKindDto> getAllKind(HttpServletResponse response, HttpServletRequest request) {
        AxiosUtil.setCors(response, request);
        List<CostTypeKindDto> allKind = costTypeKindService.getAllKind();
        return allKind;
    }

    /**
     * 导入 excel 文件
     *
     * @return
     */
    @PostMapping("/import")
    public Map<String, Object> upload(@RequestParam("file") MultipartFile file, HttpServletResponse response, HttpServletRequest request) {
        AxiosUtil.setCors(response, request);
        Map<String, Object> result = new HashMap<>();
        String fileName = file.getOriginalFilename();
        String createUsercode = request.getParameter("createUsercode");
        if (null == createUsercode || createUsercode.isEmpty()){
            result.put("success", false);
            result.put("fileName", "请登陆");
            return result;
        }

        if (!fileName.matches("^.+\\.(?i)(xls)$") && !fileName.matches("^.+\\.(?i)(xlsx)$")) {
            result.put("success", false);
            result.put("msg", "上传文件格式不正确");
            return result;
        } else {
            try {
                Boolean importResult = costTypeKindService.importByExcel(file,createUsercode);
                if (!importResult) {
                    result.put("success", false);
                    result.put("fileName", "导入失败");
                    return result;
                }
            } catch (Exception e) {
                result.put("success", false);
                result.put("msg", e.getMessage());
                e.printStackTrace();
                return result;
            }
        }
        result.put("success", true);
        result.put("fileName", fileName);
        return result;
    }

    @PostMapping("/editKind")
    public Map<String,Object> editKind(HttpServletRequest request,HttpServletResponse response){
        AxiosUtil.setCors(response,request);
        Map<String,Object> result = new HashMap<>();
        String kindNo = request.getParameter("kindNo");
        String typeNo = request.getParameter("typeNo");
        String kindName = request.getParameter("kindName");
        if (null == typeNo || typeNo.isEmpty()){
            result.put("success",false);
            result.put("msg","请选择费用大类");
            return result;
        }
        CostTypeKindDomain costTypeKindDomain = new CostTypeKindDomain();
        costTypeKindDomain.setKindNo(kindNo);
        costTypeKindDomain.setKindName(kindName);
        costTypeKindDomain.setTypeNo(typeNo);

        Integer i = costTypeKindService.update(costTypeKindDomain);
        if (null != i && i>=1){
            result.put("success",true);
            result.put("msg","费用小类已修改");
        }
        return result;
    }

    @PostMapping("/deleteKind")
    public Map<String,Object> deleteKind(HttpServletResponse response,HttpServletRequest request){
        AxiosUtil.setCors(response,request);
        Map<String,Object> result = new HashMap<>();
        String kindNo = request.getParameter("kindNo");
        Integer i = costTypeKindService.deleteKind(kindNo);
        if (null != i && i >= 1){
            result.put("success",true);
            result.put("msg","已删除");
        }else {
            result.put("success",false);
        }
        return result;
    }

    /**
     * 获取物流subjectCode
     * @param response
     * @param request
     * @return
     */
    @GetMapping("/getLogisticsCode")
    public Map<String, Object> getLogisticsCode(HttpServletResponse response,HttpServletRequest request){
        AxiosUtil.setCors(response, request);
        Map<String,Object> result = new HashMap<>();
        if(logisticsSubjectCode != null && logisticsSubjectCode.length() > 0){
            result.put("success", true);
            result.put("logisticsCode", logisticsSubjectCode);
        }else{
            result.put("success",false);
        }
        return result;
    }

    @PostMapping("/getLogisticsBank")
    public Map<String, Object> getLogisticsBank(HttpServletResponse response,HttpServletRequest request){
        AxiosUtil.setCors(response, request);
        Map<String,Object> result = new HashMap<>();
        String subSupplierName = request.getParameter("subSupplierName");
        LogisticsSupplierBankDomain bankDomain = costTypeKindService.getLogisticsBank(subSupplierName);
        if (bankDomain != null){
            result.put("success", true);
            result.put("bankInfo", bankDomain);
        }else {
            result.put("success",false);
        }
        return result;
    }
}
