package com.blt.other.module.cost.service.impl.costtemplate;

import com.bailuntec.common.StringUtils;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.blt.other.module.auth.service.UserService;
import com.blt.other.module.cost.dao.CostTemplateMapper;
import com.blt.other.module.cost.dto.QueryListReq;
import com.blt.other.module.cost.model.CostTemplate;
import com.blt.other.module.cost.model.CostTemplateBaseCol;
import com.blt.other.module.cost.model.CostTemplateCol;
import com.blt.other.module.cost.service.ICostTemplateBaseColService;
import com.blt.other.module.cost.service.ICostTemplateColService;
import com.blt.other.module.cost.service.ICostTemplateService;
import com.blt.other.module.database.model.UserDomain;
import org.springframework.context.annotation.Primary;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 * 费用单模版 服务实现类
 * </p>
 *
 * @author robbendev
 * @since 2020-10-14
 */
@Primary
@Service
public class CostTemplateServiceImpl extends ServiceImpl<CostTemplateMapper, CostTemplate> implements ICostTemplateService {


    @Resource
    ICostTemplateColService costTemplateColService;
    @Resource
    ICostTemplateBaseColService costTemplateBaseColService;
    @Resource
    UserService userService;

    @Override
    public void add(CostTemplate costTemplate) {
        UserDomain userDomain = userService.findByUserid(costTemplate.getCreateUserId());
        costTemplate.setCreateUserName(userDomain.getUsername());
        costTemplate.setUpdateUserId(userDomain.getUseridsso());
        costTemplate.setUpdateUserName(userDomain.getUsername());

        this.save(costTemplate);
        List<CostTemplateBaseCol> costTemplateBaseColList = costTemplateBaseColService.defaultBaseColList(costTemplate.getCostType());

        List<CostTemplateCol> defaultCostTemplateCol = costTemplateBaseColList.stream().map(costTemplateBaseCol -> {
            CostTemplateCol costTemplateCol = new CostTemplateCol();
            costTemplateCol.setCostTemplateBaseColId(costTemplateBaseCol.getId());
            costTemplateCol.setAutoRuleType(0);
            costTemplateCol.setCreateTime(LocalDateTime.now());
            costTemplateCol.setIsDefault(true);
            return costTemplateCol;
        })
                .collect(Collectors.toList());

        costTemplate.getCostTemplateColList().addAll(defaultCostTemplateCol);
        costTemplate.getCostTemplateColList().forEach(costTemplateCol -> costTemplateCol.setCostTemplateId(costTemplate.getId()));
        costTemplateColService.saveBatch(costTemplate.getCostTemplateColList());
    }

    @Override
    public CostTemplate queryDetail(@Nullable Integer id) {
        CostTemplate costTemplate = this.getById(id);
        if(costTemplate!=null){
            costTemplateColService.setCostTemplateCol(costTemplate);

        }
        return costTemplate;
    }

    @Override
    public void edit(CostTemplate costTemplate) {
        UserDomain userDomain = userService.findByUserid(costTemplate.getUpdateUserId());
        costTemplate.setUpdateUserId(userDomain.getUseridsso());
        costTemplate.setUpdateUserName(userDomain.getUsername());

        this.updateById(costTemplate);
    }

    @Override
    public void delete(Integer id) {
        if (id != null) {
            this.removeById(id);
            costTemplateColService.remove(new LambdaQueryWrapper<CostTemplateCol>()
                    .eq(CostTemplateCol::getCostTemplateId, id));
        }

    }

    @Override
    public List<CostTemplate> queryList(QueryListReq req) {

        LambdaQueryWrapper<CostTemplate> wrapper = new LambdaQueryWrapper<>();
        if (req.getEnableAutoReview() != null) {
            wrapper.eq(CostTemplate::getEnableAutoReview, req.getEnableAutoReview());
        }
        if (StringUtils.isNotEmpty(req.getTemplateName())) {
            wrapper.like(CostTemplate::getTemplateName, req.getTemplateName());
        }
        if (req.getCreateUserId() != null) {
            wrapper.eq(CostTemplate::getCreateUserId, req.getCreateUserId());
        }
        if (req.getUpdateUserId() != null) {
            wrapper.eq(CostTemplate::getUpdateUserId, req.getUpdateUserId());
        }
        if (req.getEnableAutoReview() != null) {
            wrapper.eq(CostTemplate::getEnableAutoReview, req.getEnableAutoReview());
        }
        if (req.getEnableDepartmentReview() != null) {
            wrapper.eq(CostTemplate::getEnableDepartmentReview, req.getEnableDepartmentReview());
        }
        if (req.getEnableFinalReview() != null) {
            wrapper.eq(CostTemplate::getEnableFinalReview, req.getEnableFinalReview());
        }
        if (req.getEnableFinancialAutoReview() != null) {
            wrapper.eq(CostTemplate::getEnableFinancialAutoReview, req.getEnableFinancialAutoReview());
        }
        if (req.getStartTime() != null) {
            wrapper.ge(CostTemplate::getLastUpdateTime, req.getStartTime());
        }
        if (req.getEndTime() != null) {
            wrapper.le(CostTemplate::getLastUpdateTime, req.getEndTime());
        }
        if (req.getCreateStartTime() != null) {
            wrapper.ge(CostTemplate::getCreateUserName, req.getCreateStartTime());
        }
        if (req.getCreateEndTime() != null) {
            wrapper.le(CostTemplate::getCreateTime, req.getCreateEndTime());
        }
        if (req.getSetAutoCheck() != null) {
            wrapper.eq(CostTemplate::getSetAutoCheck, req.getSetAutoCheck());
        }
        List<CostTemplate> costTemplateList = this.list(wrapper);
        costTemplateColService.setCostTemplateCol(costTemplateList);
        return costTemplateList;
    }
}
