package com.blt.other.module.entrepot.dao;

import com.blt.other.module.database.model.InventoryDomain;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

@Mapper
@Repository
public interface InventoryDao {

    /**
     * 根据 skucode 获取库存记录
     * @param skucode
     * @return
     */
    InventoryDomain selectBySkucode(String skucode);

    /**
     * 根据 warehouseid + skucode 获取库存记录
     * @param skucode
     * @return
     */
    InventoryDomain selectByWarehouseidAndSkucode(@Param("warehouseid")String warehouseid,@Param("skucode") String skucode);

    /**
     * 添加库存记录
     * @param inventoryDomain
     * @return
     */
    Integer insert(InventoryDomain inventoryDomain);

    /**
     * 根据 inventoryNo 获取库存记录
     * @param inventoryNo
     * @return
     */
    InventoryDomain selectByInventoryNo(String inventoryNo);

    /**
     * 更改库存记录
     * @param inventoryDomain
     * @return
     */
    Integer update(InventoryDomain inventoryDomain);

    /**
     * 获取所有库存列表
     * @return
     */
    List<InventoryDomain> selectAll();

    /**
     * 根据关键字获取库存信息
     * @param key
     * @return
     */
    List<InventoryDomain> selectByKey(@Param("key") String key);
}
