package com.blt.other.module.cost.service.impl.costcheck;

import com.blt.other.common.exception.BizRuntimeException;
import com.blt.other.module.cost.model.CostDomain;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/10/30 2:57 下午
 */
@Component
public class UnSubmitState extends CostState {

    @Autowired
    DepartmentCheckState departmentCheckState;

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void handle() {

        CostDomain costDomain = costContext.costDomain;
        //校验费用单状态 和 当前处理用户
        if (costDomain.getCostStatus() != CostDomain.STATUS_UN_SUBMIT ||
                costDomain.getCostStatus() != CostDomain.STATUS_REJECT ||
                !costDomain.getCreateUserid().equals(costContext.currentUserId)) {
            throw new BizRuntimeException("invalid status");
        }

        //更新费用单
        costDomain.setCostStatus(CostDomain.STATUS_DEPARTMENT_CHECK);
        costDao.updateById(costDomain);
        costLogService.save(costDomain.getCostNo(), costContext.currentUserId, "提交费用单");


        nextState(departmentCheckState);
        //发布到总线尝试下个环节的自动审核
        costSubscribe.subscribe(costContext);
    }

    @Override
    public void refuse(String rejectReason) {
        throw new BizRuntimeException("unsupported operate ");
    }
}
