package com.blt.other.module.auth.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.blt.other.module.auth.dao.OaDepartmentMapper;
import com.blt.other.module.auth.dao.OaUserMapper;
import com.blt.other.module.auth.model.OaDepartment;
import com.blt.other.module.auth.model.OaUser;
import com.blt.other.module.auth.service.IOaUserService;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author robbendev
 * @since 2020-10-12
 */
@Service
public class OaUserServiceImpl extends ServiceImpl<OaUserMapper, OaUser> implements IOaUserService {

    @Resource
    OaDepartmentMapper oaDepartmentMapper;

    @Override
    public List<OaUser> queryList(@Nullable Integer primaryDepartmentId,
                                  @Nullable Integer oaCompanyId) {
        LambdaQueryWrapper<OaUser> wrapper = new LambdaQueryWrapper<>();
        if (primaryDepartmentId != null) {
            wrapper.eq(OaUser::getPrimaryDepartmentId, primaryDepartmentId);
        }
        if (oaCompanyId != null) {
            wrapper.eq(OaUser::getCompanyId, oaCompanyId);
        }
        List<OaUser> oaUserList = this.list(wrapper);

        List<OaDepartment> oaDepartmentList = oaDepartmentMapper.selectList(new LambdaQueryWrapper<OaDepartment>()
                .in(OaDepartment::getDepartmentId, oaUserList.stream().map(OaUser::getDepartmentId).collect(Collectors.toList())));

        List<OaUser> mangeUserList = this.list(new LambdaQueryWrapper<OaUser>()
                .in(OaUser::getUserName, oaDepartmentList.stream().map(OaDepartment::getManageUser1).collect(Collectors.toList())));
        oaUserList.addAll(mangeUserList);
        return oaUserList;
    }
}
