package com.blt.other.common.util;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AxiosUtil {

    /**
     * 设置跨域请求头
     *
     * @param response
     * @param request
     */
    public static void setCors(HttpServletResponse response, HttpServletRequest request) {
        String origin = request.getHeader("Origin");
        response.setHeader("Access-Control-Allow-Origin", origin);
        response.setHeader("Access-Control-Allow-Credentials", "true");
    }

    /**
     * 获取 Origin
     *
     * @param request
     */
    public static String getOrigin(HttpServletRequest request) {
        String origin = request.getHeader("Origin");
        return origin;
    }
}
