package com.blt.other.other_cost.controller;

import com.blt.other.other_commons.utils.AxiosUtil;
import com.blt.other.other_cost.service.CostPlanSearchService;
import com.blt.other.other_cost.service.CostPlanService;
import com.blt.other.other_cost.service.CostService;
import com.blt.other.other_database.model.CostPlanDomain;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("/cost/plan")
public class CostPlanSearchController {

    @Autowired
    private CostPlanService costPlanService;

    @Autowired
    private CostPlanSearchService costPlanSearchService;

    @PostMapping("/search/key")
    public Map<String,Object> searchByKey(HttpServletResponse response, HttpServletRequest request){
        AxiosUtil.setCors(response,request);
        String searchKey = request.getParameter("searchKey");
        Map<String, Object> map = costPlanSearchService.searchByKey(searchKey);
        List<CostPlanDomain> list = (List<CostPlanDomain>)map.get("list");
        map.put("list",costPlanService.domainListToDtoList(list));
        return map;
    }
}
