package com.blt.other.module.cost.service.impl.costcheck;

import com.blt.other.common.exception.BizRuntimeException;
import com.blt.other.module.auth.model.CostReviewer;
import com.blt.other.module.cost.dao.CostCompanyDao;
import com.blt.other.module.cost.model.CostDomain;
import com.blt.other.module.cost.model.CostTemplate;
import com.blt.other.module.database.model.CostCompanyDomain;
import com.blt.other.module.database.model.CostLogDomain;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/10/30 2:57 下午
 */
@Component
public class FinalCheckState extends CostState {

    @Resource
    UnPayState unPayState;
    @Resource
    CostCompanyDao costCompanyDao;


    @Transactional(rollbackFor = Exception.class)
    @Override
    public void handle() {
        CostDomain costDomain = costContext.costDomain;
        Integer currentUserId = costContext.currentUserId;
        CostTemplate costTemplate = costTemplateService.queryDetail(costDomain.getCostTemplateId());
        CostCompanyDomain costCompany = costCompanyDao.selectByNo(costDomain.getCompanyNo());


        //check status
        if (!costDomain.getCostStatus().equals(CostDomain.STATUS_FINAL_CHECK)) {
            throw new BizRuntimeException("invalid status");
        }

        //如果是默认模版 不需要最终审核
        if (costTemplate.getIsDefault()) {
            costDomain.setCostStatus(CostDomain.STATUS_UN_PAY);
            costDao.updateById(costDomain);
            costLogService.saveByManage(costDomain.getCostNo(), "最终审核自动通过", CostLogDomain.DEPARTMENT_AUTO_PASS);

            //流转状态
            nextState(unPayState);
            //通知财务系统
            costContext.costService.toFinancial(costDomain);
            return;
        }


        //如果不需要审核 直接通过
        if (!costTemplate.shouldFinalCheck(costDomain.getAmount())) {
            costDomain.setCostStatus(CostDomain.STATUS_UN_PAY);
            costDao.updateById(costDomain);
            costLogService.saveByManage(costDomain.getCostNo(), "金额不够最终审核标准，无需最终审核", null);

            //通知财务系统
            costContext.costService.toFinancial(costDomain);
            return;
        }

        //需要自动审核
        if (costTemplate.shouldFinalAutoCheck()) {
            //自动审核通过
            if (this.autoCheck(costDomain)) {
                costDomain.setCostStatus(CostDomain.STATUS_UN_PAY);
                costDao.updateById(costDomain);
                costLogService.saveByManage(costDomain.getCostNo(), "最终审核自动通过", CostLogDomain.FINAL_AUTO_PASS);

                //流转状态
                nextState(unPayState);
                //通知财务系统
                costContext.costService.toFinancial(costDomain);
                return;
            }
        }

        if (costContext.currentUserId != null) {
            //人工审核通过
            if (costReviewerMapper.queryOne(costCompany.getId(), CostReviewer.finalReviewer, currentUserId) != null) {
                costDomain.setCostStatus(CostDomain.STATUS_UN_PAY);
                costDao.updateById(costDomain);

                costLogService.save(costDomain.getCostNo(), currentUserId, "最终审核通过", CostLogDomain.FINAL_MANUAL_PASS);

                //流转状态
                nextState(unPayState);
                //通知财务系统
                costContext.costService.toFinancial(costDomain);
            }

            //人工审核没权限
            else {
                throw new BizRuntimeException("current user no authority");
            }
        }
    }

    @Override
    public void refuse(String rejectReason) {
        CostDomain costDomain = costContext.costDomain;
        Integer currentUserId = costContext.currentUserId;

        CostCompanyDomain costCompany = costCompanyDao.selectByNo(costDomain.getCompanyNo());

        //check status
        if (!costDomain.getCostStatus().equals(CostDomain.STATUS_FINAL_CHECK)) {
            throw new BizRuntimeException("invalid status");
        }

        //人工审核通过
        if (costReviewerMapper.queryOne(costCompany.getId(), CostReviewer.finalReviewer, currentUserId) == null) {
            throw new BizRuntimeException("current user no authority");
        }

        costContext.costService.resetCost(costDomain.getCostNo());

        costLogService.save(costDomain.getCostNo(), currentUserId, "最终审核拒绝,理由:" + rejectReason, CostLogDomain.TYPE_UPDATE);

    }
}
